/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.impl.client;

import java.io.IOException;
import java.net.Socket;
import shadowed.org.apache.http.ConnectionReuseStrategy;
import shadowed.org.apache.http.HttpEntity;
import shadowed.org.apache.http.HttpException;
import shadowed.org.apache.http.HttpHost;
import shadowed.org.apache.http.HttpResponse;
import shadowed.org.apache.http.HttpVersion;
import shadowed.org.apache.http.auth.AuthSchemeRegistry;
import shadowed.org.apache.http.auth.AuthScope;
import shadowed.org.apache.http.auth.AuthState;
import shadowed.org.apache.http.auth.Credentials;
import shadowed.org.apache.http.client.config.RequestConfig;
import shadowed.org.apache.http.client.params.HttpClientParamConfig;
import shadowed.org.apache.http.client.protocol.RequestClientConnControl;
import shadowed.org.apache.http.config.ConnectionConfig;
import shadowed.org.apache.http.conn.HttpConnectionFactory;
import shadowed.org.apache.http.conn.ManagedHttpClientConnection;
import shadowed.org.apache.http.conn.routing.HttpRoute;
import shadowed.org.apache.http.conn.routing.RouteInfo;
import shadowed.org.apache.http.entity.BufferedHttpEntity;
import shadowed.org.apache.http.impl.DefaultConnectionReuseStrategy;
import shadowed.org.apache.http.impl.auth.BasicSchemeFactory;
import shadowed.org.apache.http.impl.auth.DigestSchemeFactory;
import shadowed.org.apache.http.impl.auth.HttpAuthenticator;
import shadowed.org.apache.http.impl.auth.KerberosSchemeFactory;
import shadowed.org.apache.http.impl.auth.NTLMSchemeFactory;
import shadowed.org.apache.http.impl.auth.SPNegoSchemeFactory;
import shadowed.org.apache.http.impl.client.BasicCredentialsProvider;
import shadowed.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import shadowed.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import shadowed.org.apache.http.impl.execchain.TunnelRefusedException;
import shadowed.org.apache.http.message.BasicHttpRequest;
import shadowed.org.apache.http.params.BasicHttpParams;
import shadowed.org.apache.http.params.HttpParamConfig;
import shadowed.org.apache.http.params.HttpParams;
import shadowed.org.apache.http.protocol.BasicHttpContext;
import shadowed.org.apache.http.protocol.HttpProcessor;
import shadowed.org.apache.http.protocol.HttpRequestExecutor;
import shadowed.org.apache.http.protocol.ImmutableHttpProcessor;
import shadowed.org.apache.http.protocol.RequestTargetHost;
import shadowed.org.apache.http.protocol.RequestUserAgent;
import shadowed.org.apache.http.util.Args;
import shadowed.org.apache.http.util.EntityUtils;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams params) {
        this(null, HttpParamConfig.getConnectionConfig(params), HttpClientParamConfig.getRequestConfig(params));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        HttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getHostName(), 80, host.getSchemeName());
        }
        HttpRoute route = new HttpRoute(host, this.requestConfig.getLocalAddress(), proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.create(route, this.connectionConfig);
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", host.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.generateAuthResponse(connect, this.proxyAuthState, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }
}

