/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.protocol;

import java.io.IOException;
import shadowed.org.apache.http.HttpEntityEnclosingRequest;
import shadowed.org.apache.http.HttpException;
import shadowed.org.apache.http.HttpRequest;
import shadowed.org.apache.http.HttpRequestInterceptor;
import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.protocol.HttpContext;
import shadowed.org.apache.http.protocol.HttpDateGenerator;
import shadowed.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

