/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.protocol;

import java.io.IOException;
import shadowed.org.apache.http.HttpEntity;
import shadowed.org.apache.http.HttpException;
import shadowed.org.apache.http.HttpResponse;
import shadowed.org.apache.http.HttpResponseInterceptor;
import shadowed.org.apache.http.HttpVersion;
import shadowed.org.apache.http.ProtocolException;
import shadowed.org.apache.http.ProtocolVersion;
import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.protocol.HttpContext;
import shadowed.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseContent
implements HttpResponseInterceptor {
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (this.overwrite) {
            response.removeHeaders("Transfer-Encoding");
            response.removeHeaders("Content-Length");
        } else {
            if (response.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (response.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            if (entity.isChunked() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response.addHeader("Transfer-Encoding", "chunked");
            } else if (len >= 0L) {
                response.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !response.containsHeader("Content-Type")) {
                response.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !response.containsHeader("Content-Encoding")) {
                response.addHeader(entity.getContentEncoding());
            }
        } else {
            int status = response.getStatusLine().getStatusCode();
            if (status != 204 && status != 304 && status != 205) {
                response.addHeader("Content-Length", "0");
            }
        }
    }
}

