/*
 * Decompiled with CFR 0.152.
 */
package com.agnor99.better_portal_opening;

import java.util.Map;
import java.util.Optional;
import net.minecraft.block.PortalSize;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PortalOpener {
    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent.Arrow arrowImpactEvent) {
        if (!(arrowImpactEvent.getArrow() instanceof ArrowEntity)) {
            return;
        }
        ArrowEntity arrow = (ArrowEntity)arrowImpactEvent.getArrow();
        if (!arrow.func_70027_ad()) {
            return;
        }
        if (!arrowImpactEvent.getRayTraceResult().func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)) {
            return;
        }
        BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)arrowImpactEvent.getRayTraceResult();
        BlockPos pos = rayTraceResult.func_216350_a().func_177967_a(rayTraceResult.func_216354_b(), 1);
        if (PortalOpener.createPortal(arrow.field_70170_p, pos)) {
            arrow.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onSwordSwing(PlayerInteractEvent.LeftClickBlock leftClickBlockEvent) {
        if (!PortalOpener.validWorld(leftClickBlockEvent.getPlayer().field_70170_p)) {
            return;
        }
        ItemStack itemStack = leftClickBlockEvent.getItemStack();
        if (itemStack.func_190926_b() || !itemStack.func_77948_v()) {
            return;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        if (!enchantments.containsKey(Enchantments.field_77334_n)) {
            return;
        }
        if (PortalOpener.createPortal(leftClickBlockEvent.getWorld(), leftClickBlockEvent.getPos().func_177972_a(leftClickBlockEvent.getFace())) && itemStack.func_77984_f()) {
            itemStack.func_222118_a(1, (LivingEntity)leftClickBlockEvent.getPlayer(), player -> player.func_213334_d(leftClickBlockEvent.getHand()));
        }
    }

    private static boolean createPortal(World world, BlockPos pos) {
        if (PortalOpener.validWorld(world)) {
            Optional optional = PortalSize.func_242964_a((IWorld)world, (BlockPos)pos, (Direction.Axis)Direction.Axis.X);
            if ((optional = ForgeEventFactory.onTrySpawnPortal((IWorld)world, (BlockPos)pos, (Optional)optional)).isPresent()) {
                ((PortalSize)optional.get()).func_150859_c();
                return true;
            }
        }
        return false;
    }

    private static boolean validWorld(World world) {
        return !world.func_201670_d() && (world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == World.field_234919_h_);
    }
}

