/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.crt.crops;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.blocks.MCBlockState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.botanypots.ZenCrop")
public class ZenCrop {
    private final CropInfo internal;

    public ZenCrop(String id, IIngredient seed, MCBlockState[] display, int ticks, String[] categories, int lightLevel) {
        this(new CropInfo(ResourceLocation.func_208304_a((String)id), seed.asVanillaIngredient(), new HashSet<String>(Arrays.asList(categories)), ticks, new ArrayList<HarvestEntry>(), ZenCrop.getBlockStates(display), Optional.of(lightLevel)));
    }

    public ZenCrop(String id, IIngredient seed, MCBlockState[] display, int ticks, String[] categories) {
        this(new CropInfo(ResourceLocation.func_208304_a((String)id), seed.asVanillaIngredient(), new HashSet<String>(Arrays.asList(categories)), ticks, new ArrayList<HarvestEntry>(), ZenCrop.getBlockStates(display), Optional.empty()));
    }

    public ZenCrop(CropInfo crop) {
        this.internal = crop;
    }

    @ZenCodeType.Method
    public ZenCrop addCategory(String category) {
        this.internal.getSoilCategories().add(category);
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop removeCategory(String category) {
        this.internal.getSoilCategories().remove(category);
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop clearCategories() {
        this.internal.getSoilCategories().clear();
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop addDrop(IItemStack item, float chance) {
        return this.addDrop(item, chance, 1);
    }

    @ZenCodeType.Method
    public ZenCrop addDrop(IItemStack item, float chance, int rolls) {
        return this.addDrop(item, chance, rolls, rolls);
    }

    @ZenCodeType.Method
    public ZenCrop addDrop(IItemStack item, float chance, int min, int max) {
        this.internal.getResults().add(new HarvestEntry(chance, item.getInternal(), min, max));
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop clearDrops() {
        this.internal.getResults().clear();
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop removeDrop(IIngredient toRemove) {
        Ingredient ingredient = toRemove.asVanillaIngredient();
        this.internal.getResults().removeIf(drop -> ingredient.test(drop.getItem()));
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop setGrowthTicks(int ticks) {
        this.internal.setGrowthTicks(ticks);
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop setSeed(IIngredient seed) {
        this.internal.setSeed(seed.asVanillaIngredient());
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop setDisplay(MCBlockState state) {
        this.internal.setDisplayBlock(ZenCrop.getBlockStates(state));
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop setDisplay(MCBlockState[] states) {
        this.internal.setDisplayBlock(ZenCrop.getBlockStates(states));
        return this;
    }

    @ZenCodeType.Method
    public ZenCrop setLightLevel(int lightLevel) {
        this.internal.setLightLevel(lightLevel);
        return this;
    }

    public CropInfo getInternal() {
        return this.internal;
    }

    public static List<BlockState> getBlockStates(Collection<MCBlockState> states) {
        return states.stream().map(MCBlockState::getInternal).collect(Collectors.toList());
    }

    public static List<MCBlockState> getMCBlockStates(Collection<BlockState> states) {
        return states.stream().map(MCBlockState::new).collect(Collectors.toList());
    }

    public static DisplayableBlockState[] getBlockStates(MCBlockState ... states) {
        return (DisplayableBlockState[])Arrays.stream(states).map(state -> new DisplayableBlockState(state.getInternal())).toArray(DisplayableBlockState[]::new);
    }

    public static MCBlockState[] getMCBlockStates(BlockState ... states) {
        return (MCBlockState[])Arrays.stream(states).map(MCBlockState::new).toArray(MCBlockState[]::new);
    }
}

