/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBotanyPot
extends Block
implements IGrowable {
    private static final ITextComponent TOOLTIP_NORMAL = new TranslationTextComponent("botanypots.tooltip.pot.normal").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_HOPPER = new TranslationTextComponent("botanypots.tooltip.pot.hopper").func_240699_a_(TextFormatting.GRAY);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(1.25f, 4.2f).func_226896_b_();
    private final boolean hopper;
    public static List<Block> botanyPots = NonNullList.func_191196_a();

    public BlockBotanyPot() {
        this(false);
    }

    public BlockBotanyPot(boolean hopper) {
        super(properties);
        this.hopper = hopper;
        botanyPots.add(this);
    }

    public boolean isHopper() {
        return this.hopper;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (player.func_225608_bj_()) {
                CropInfo crop = pot.getCrop();
                if (crop != null) {
                    ItemStack seedStack = pot.getCropStack();
                    if (!seedStack.func_190926_b() && pot.canSetCrop(null)) {
                        pot.setCrop(null, ItemStack.field_190927_a);
                        BlockBotanyPot.dropItem(seedStack.func_77946_l(), world, pos);
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    ItemStack soilStack;
                    SoilInfo soil = pot.getSoil();
                    if (soil != null && !(soilStack = pot.getSoilStack()).func_190926_b() && pot.canSetSoil(null)) {
                        pot.setSoil(null, ItemStack.field_190927_a);
                        BlockBotanyPot.dropItem(soilStack.func_77946_l(), world, pos);
                        return ActionResultType.SUCCESS;
                    }
                }
            } else {
                ItemStack heldItem = player.func_184586_b(hand);
                if (!heldItem.func_190926_b()) {
                    FertilizerInfo fertilizerForStack;
                    if (pot.getSoil() == null) {
                        SoilInfo soilForStack = BotanyPotHelper.getSoilForItem(heldItem);
                        if (soilForStack != null && pot.canSetSoil(soilForStack)) {
                            ItemStack inStack = heldItem.func_77946_l();
                            inStack.func_190920_e(1);
                            pot.setSoil(soilForStack, inStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            return ActionResultType.SUCCESS;
                        }
                    } else if (pot.getCrop() == null) {
                        CropInfo cropForStack = BotanyPotHelper.getCropForItem(heldItem);
                        if (cropForStack != null && BotanyPotHelper.isSoilValidForCrop(pot.getSoil(), cropForStack) && pot.canSetCrop(cropForStack)) {
                            ItemStack inStack = heldItem.func_77946_l();
                            inStack.func_190920_e(1);
                            pot.setCrop(cropForStack, inStack);
                            if (!player.func_184812_l_()) {
                                heldItem.func_190918_g(1);
                            }
                            return ActionResultType.SUCCESS;
                        }
                    } else if (!pot.canHarvest() && (fertilizerForStack = BotanyPotHelper.getFertilizerForItem(heldItem)) != null) {
                        int ticksToGrow = fertilizerForStack.getTicksToGrow(world.field_73012_v, pot.getSoil(), pot.getCrop());
                        pot.addGrowth(ticksToGrow);
                        if (!world.field_72995_K) {
                            world.func_217379_c(2005, tile.func_174877_v(), 0);
                        }
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                        return ActionResultType.SUCCESS;
                    }
                }
                if (!this.isHopper() && pot.canHarvest()) {
                    pot.onCropHarvest();
                    pot.resetGrowthTime();
                    for (ItemStack stack : BotanyPotHelper.getHarvestStacks(world, pot.getCrop())) {
                        BlockBotanyPot.dropItem(stack, world, pos);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityBotanyPot();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tileEntity;
            if (pot.getSoil() != null) {
                BlockBotanyPot.dropItem(pot.getSoilStack(), worldIn, pos);
            }
            if (pot.getCrop() != null) {
                BlockBotanyPot.dropItem(pot.getCropStack(), worldIn, pos);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public static void dropItem(ItemStack item, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            double offsetX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offsetY = (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity droppedItemEntity = new ItemEntity(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, item);
            droppedItemEntity.func_174869_p();
            world.func_217376_c((Entity)droppedItemEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.isHopper() ? TOOLTIP_HOPPER : TOOLTIP_NORMAL);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            return pot.hasSoilAndCrop() && !pot.isDoneGrowing();
        }
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState myState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            ((TileEntityBotanyPot)tile).onTileTick();
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tile;
        if (world.func_175667_e(pos) && (tile = world.func_175625_s(pos)) instanceof TileEntityBotanyPot) {
            return ((TileEntityBotanyPot)tile).isDoneGrowing() ? 15 : super.func_180641_l(blockState, world, pos);
        }
        return super.func_180641_l(blockState, world, pos);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int light = super.getLightValue(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBotanyPot) {
            int cropLight;
            int soilLight;
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (pot.getSoil() != null && (soilLight = pot.getSoil().getLightLevel(world, pos)) > light) {
                light = soilLight;
            }
            if (pot.getCrop() != null && (cropLight = pot.getCrop().getLightLevel(world, pos)) > light) {
                light = cropLight;
            }
        }
        return light;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }
}

