/*
 * Decompiled with CFR 0.152.
 */
package com.bundles.event;

import com.bundles.init.BundleResources;
import com.bundles.network.message.BundleServerMessage;
import com.bundles.util.BundleItemUtils;
import com.bundles.util.BundleTooltipUtil;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class BundleEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseReleased(GuiScreenEvent.MouseReleasedEvent event) {
        ClientPlayerEntity player;
        ContainerScreen containerScreen;
        Slot slot;
        if (!event.isCanceled() && event.getGui() instanceof ContainerScreen && (slot = (containerScreen = (ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && !(slot instanceof CraftingResultSlot) && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            ItemStack draggedItemStack = player.field_71071_by.func_70445_o();
            ItemStack slotStack = slot.func_75211_c();
            Container container = containerScreen.func_212873_a_();
            if (slot.func_82869_a((PlayerEntity)player) && slot.func_111238_b() && container.func_94530_a(draggedItemStack, slot) && slot.func_75214_a(draggedItemStack) && slot.func_75216_d() && event.getButton() == 0 && BundleItemUtils.isBundle(draggedItemStack) && BundleItemUtils.canAddItemStackToBundle(draggedItemStack, slotStack)) {
                try {
                    Field slotIndexField = BundleEvents.getSlotIndexField();
                    if (slotIndexField != null) {
                        slotIndexField.setAccessible(true);
                        int slotIndex = player.func_184812_l_() && container instanceof CreativeScreen.CreativeContainer ? (Integer)slotIndexField.get(slot) : slot.field_75222_d;
                        BundleResources.NETWORK.sendToServer((Object)new BundleServerMessage(draggedItemStack, slotIndex, false));
                        event.setResult(Event.Result.DENY);
                        event.setCanceled(true);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseClick(GuiScreenEvent.MouseClickedEvent event) {
        ClientPlayerEntity player;
        ContainerScreen containerScreen;
        Slot slot;
        if (!event.isCanceled() && event.getGui() instanceof ContainerScreen && (slot = (containerScreen = (ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && !(slot instanceof CraftingResultSlot) && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            ItemStack slotStack = slot.func_75211_c();
            if (slot.func_82869_a((PlayerEntity)player) && slot.func_111238_b() && slot.func_75216_d() && event.getButton() == 1 && BundleItemUtils.isBundle(slotStack)) {
                try {
                    Field slotIndexField = BundleEvents.getSlotIndexField();
                    if (slotIndexField != null) {
                        slotIndexField.setAccessible(true);
                        int slotIndex = player.func_184812_l_() && containerScreen.func_212873_a_() instanceof CreativeScreen.CreativeContainer ? (Integer)slotIndexField.get(slot) : slot.field_75222_d;
                        BundleResources.NETWORK.sendToServer((Object)new BundleServerMessage(slotStack, player.func_184812_l_() ? slotIndex : slot.field_75222_d, true));
                        event.setResult(Event.Result.DENY);
                        event.setCanceled(true);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Field getSlotIndexField() {
        Field slotIndexField = null;
        try {
            slotIndexField = Slot.class.getDeclaredField("slotIndex");
        }
        catch (NoSuchFieldException e) {
            try {
                slotIndexField = Slot.class.getDeclaredField("field_75225_a");
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
        }
        return slotIndexField;
    }

    @SubscribeEvent
    public static void onTooltipRender(RenderTooltipEvent.Pre event) {
        if (BundleItemUtils.isBundle(event.getStack())) {
            event.setCanceled(true);
            BundleTooltipUtil.drawBundleTooltip(event);
        }
    }
}

