/*
 * Decompiled with CFR 0.152.
 */
package com.bundles.network.handler;

import com.bundles.network.message.BundleClientMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class BundleClientMessageHandler {
    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return "1.3".equals(protocolVersion);
    }

    public static void onMessageReceived(BundleClientMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context context = ctxSupplier.get();
        LogicalSide side = context.getDirection().getReceptionSide();
        context.setPacketHandled(true);
        if (!side.isClient()) {
            return;
        }
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity == null) {
            return;
        }
        context.enqueueWork(() -> BundleClientMessageHandler.processMessage(message, playerEntity));
    }

    private static void processMessage(BundleClientMessage message, ClientPlayerEntity player) {
        Container container = player.field_71070_bA;
        Slot slot = container.func_75139_a(message.slotId);
        slot.func_75215_d(message.slotStack);
        if (message.empty) {
            if (message.playEmptySound) {
                player.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            }
        } else {
            player.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.field_71071_by.func_70437_b(message.bundle);
        }
    }
}

