/*
 * Decompiled with CFR 0.152.
 */
package com.bundles.util;

import com.bundles.util.BundleItemUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class BundleTooltipUtil {
    private static List<ItemStack> CACHED_ITEM_STACKS;
    private static List<ItemStack> CACHED_TOOLTIP_ITEM_STACKS;
    private static HashMap<ItemStack, Map.Entry<Integer, Integer>> CACHED_TOOLTIP_POSITIONS;

    public static void drawBundleTooltip(RenderTooltipEvent.Pre event) {
        boolean useCached;
        ItemStack stack = event.getStack();
        ArrayList<String> textLines = event.getLines();
        int mouseX = event.getX();
        int mouseY = event.getY();
        int screenWidth = event.getScreenWidth();
        int screenHeight = event.getScreenHeight();
        int maxTextWidth = event.getMaxWidth();
        FontRenderer font = event.getFontRenderer();
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        List<ItemStack> bundleItems = BundleItemUtils.getItemsFromBundle(stack);
        boolean bl = useCached = CACHED_ITEM_STACKS != null && bundleItems.size() == CACHED_ITEM_STACKS.size();
        if (useCached) {
            for (int i = 0; i < bundleItems.size(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)bundleItems.get(i), (ItemStack)CACHED_ITEM_STACKS.get(i))) continue;
                useCached = false;
                break;
            }
        }
        if (!useCached) {
            CACHED_ITEM_STACKS = bundleItems;
            CACHED_TOOLTIP_POSITIONS = new HashMap();
            ArrayList<ItemStack> tooltipItems = new ArrayList<ItemStack>();
            Random random = new Random();
            bundleItems.forEach(x -> {
                for (int i = 0; i < x.func_190916_E(); ++i) {
                    ItemStack tooltipStack = x.func_77946_l();
                    tooltipStack.func_190920_e(1);
                    tooltipStack.func_200302_a((ITextComponent)new StringTextComponent("stack_" + i));
                    tooltipItems.add(tooltipStack);
                    CACHED_TOOLTIP_POSITIONS.put(tooltipStack, new AbstractMap.SimpleEntry<Integer, Integer>(random.nextInt(4), random.nextInt(4)));
                }
            });
            Collections.shuffle(tooltipItems);
            CACHED_TOOLTIP_ITEM_STACKS = tooltipItems;
        }
        int rows = Math.min(CACHED_TOOLTIP_ITEM_STACKS.size() / 16 + 1, 4);
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (String textLine : textLines) {
            int textLineWidth = font.func_78256_a(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (int i = 0; i < textLines.size(); ++i) {
                String textLine = (String)textLines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = font.func_78256_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        if (!CACHED_TOOLTIP_ITEM_STACKS.isEmpty()) {
            tooltipTextWidth += (rows == 1 && CACHED_TOOLTIP_ITEM_STACKS.size() <= 9 ? 0 : 16) * 3;
            tooltipHeight += rows * 8;
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack textStack = new MatrixStack();
        textStack.func_227861_a_(0.0, 0.0, 400.0);
        Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            String line = (String)textLines.get(lineNumber);
            if (line != null) {
                font.func_228079_a_(line, (float)tooltipX, (float)tooltipY, -1, true, textLocation, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        tooltipX -= 4;
        tooltipY -= 5;
        float prevZLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
        Minecraft.func_71410_x().func_175599_af().field_77023_b = 401.0f;
        for (int r = 0; r < rows; ++r) {
            List<ItemStack> rowItemStacks = CACHED_TOOLTIP_ITEM_STACKS.subList(r * 16, Math.min(CACHED_TOOLTIP_ITEM_STACKS.size(), (r + 1) * 16 - 1));
            for (int i = 0; i < rowItemStacks.size(); ++i) {
                ItemStack bundleItem = rowItemStacks.get(i);
                Map.Entry<Integer, Integer> position = CACHED_TOOLTIP_POSITIONS.get(bundleItem);
                BundleTooltipUtil.renderItemModelIntoGUI(bundleItem, tooltipX + 8 * (i % 16) + position.getKey(), tooltipY + 8 * r + position.getValue());
            }
        }
        Minecraft.func_71410_x().func_175599_af().field_77023_b = prevZLevel;
        renderType.func_228461_a_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    private static void renderItemModelIntoGUI(ItemStack stack, int x, int y) {
        boolean flag;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        IBakedModel bakedmodel = itemRenderer.func_184393_a(stack, null, null);
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Objects.requireNonNull(Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_110575_b)).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + itemRenderer.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)8.0f, (float)8.0f, (float)8.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }
}

