/*
 * Decompiled with CFR 0.152.
 */
package com.bundles.network.handler;

import com.bundles.init.BundleResources;
import com.bundles.network.message.BundleClientMessage;
import com.bundles.network.message.BundleServerMessage;
import com.bundles.util.BundleItemUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class BundleServerMessageHandler {
    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return "1.3".equals(protocolVersion);
    }

    public static void onMessageReceived(BundleServerMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context context = ctxSupplier.get();
        LogicalSide side = context.getDirection().getReceptionSide();
        context.setPacketHandled(true);
        if (!side.isServer()) {
            return;
        }
        ServerPlayerEntity playerEntity = context.getSender();
        if (playerEntity == null) {
            return;
        }
        context.enqueueWork(() -> BundleServerMessageHandler.processMessage(message, playerEntity));
    }

    private static void processMessage(BundleServerMessage message, ServerPlayerEntity playerEntity) {
        Container container = playerEntity.field_71070_bA;
        Slot slot = container.func_75139_a(message.slotId);
        ItemStack slotStack = slot.func_75211_c();
        boolean playEmptySound = false;
        if (message.empty) {
            playEmptySound = !BundleItemUtils.isEmpty(message.bundle);
            BundleItemUtils.emptyBundle(message.bundle, (PlayerEntity)playerEntity);
            slotStack = message.bundle;
        } else {
            BundleItemUtils.addItemStackToBundle(message.bundle, slotStack);
            if (!playerEntity.func_184812_l_() || !(container instanceof PlayerContainer)) {
                playerEntity.field_71071_by.func_70437_b(message.bundle);
            }
        }
        slot.func_75215_d(slotStack);
        BundleResources.NETWORK.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new BundleClientMessage(message.bundle, message.slotId, slotStack, message.empty, playEmptySound));
    }
}

