/*
 * Decompiled with CFR 0.152.
 */
package com.bundles.util;

import com.bundles.init.BundleResources;
import com.bundles.item.BundleItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;

public final class BundleItemUtils {
    public static boolean isBundle(ItemStack bundle) {
        return bundle.func_77973_b() instanceof BundleItem;
    }

    public static boolean isFull(ItemStack bundle) {
        return BundleItemUtils.getBundleItemsCount(bundle) >= bundle.func_77958_k();
    }

    public static boolean isEmpty(ItemStack bundle) {
        return BundleItemUtils.getBundleItemsCount(bundle) == 0;
    }

    public static boolean canAddItemStackToBundle(ItemStack bundle, ItemStack stack) {
        if (!BundleItemUtils.isBundle(bundle) || BundleItemUtils.isFull(bundle) || BundleItemUtils.isIgnored(stack)) {
            return false;
        }
        ItemStack bundleItemStack = BundleItemUtils.getItemStackFor(bundle, stack);
        return bundleItemStack.func_190926_b() || stack.func_77976_d() == 1 || bundleItemStack.func_190916_E() < BundleItemUtils.getMaxStackSizeForBundle(stack);
    }

    private static boolean isIgnored(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            ITag blockTag = BlockTags.func_199896_a().func_199910_a(BundleResources.BUNDLE_IGNORED_BLOCKS_TAG);
            return blockTag != null && blockTag.func_230235_a_((Object)((BlockItem)item).func_179223_d());
        }
        ITag itemTag = ItemTags.func_199903_a().func_199910_a(BundleResources.BUNDLE_IGNORED_ITEMS_TAG);
        return itemTag != null && itemTag.func_230235_a_((Object)item);
    }

    public static void addItemStackToBundle(ItemStack bundle, ItemStack stack) {
        if (!BundleItemUtils.isBundle(bundle) || BundleItemUtils.isFull(bundle) || BundleItemUtils.isBundle(stack)) {
            return;
        }
        ItemStack stackToAdd = stack.func_77946_l();
        int maxItemsToAdd = bundle.func_77958_k() - BundleItemUtils.getBundleItemsCount(bundle);
        stackToAdd.func_190920_e(Math.min(BundleItemUtils.getMaxStackSizeForBundleToInsert(stackToAdd), maxItemsToAdd));
        CompoundNBT bundleTag = bundle.func_196082_o();
        ListNBT items = bundleTag.func_150295_c("bundle_items", 10);
        CompoundNBT itemStackNbt = new CompoundNBT();
        ItemStack stackFromBundle = BundleItemUtils.getItemStackFor(bundle, stackToAdd);
        int index = BundleItemUtils.getItemStackIndex(bundle, stackFromBundle);
        if (!stackFromBundle.func_190926_b() && stack.func_77976_d() > 1) {
            stackToAdd.func_190920_e(Math.min(stackToAdd.func_190916_E(), BundleItemUtils.getMaxStackSizeForBundle(stack) - stackFromBundle.func_190916_E()));
            stackFromBundle.func_190920_e(stackFromBundle.func_190916_E() + stackToAdd.func_190916_E());
        }
        if (index != -1 && stack.func_77976_d() > 1) {
            stackFromBundle.func_77955_b(itemStackNbt);
            items.remove(index);
            items.add(index, (INBT)itemStackNbt);
        } else {
            stackToAdd.func_77955_b(itemStackNbt);
            items.add((Object)itemStackNbt);
        }
        bundleTag.func_218657_a("bundle_items", (INBT)items);
        bundle.func_77982_d(bundleTag);
        stack.func_190920_e(stack.func_190916_E() - stackToAdd.func_190916_E());
    }

    public static void emptyBundle(ItemStack bundle, PlayerEntity player) {
        if (!BundleItemUtils.isBundle(bundle) || BundleItemUtils.isEmpty(bundle)) {
            return;
        }
        BundleItemUtils.getItemsFromBundle(bundle).forEach(item -> {
            if (!player.func_191521_c(item)) {
                if (!player.func_184812_l_()) {
                    player.func_71019_a(item, true);
                }
            } else if (item.func_190916_E() > 0 && !player.func_184812_l_()) {
                player.func_71019_a(item, true);
            }
        });
        CompoundNBT bundleTag = bundle.func_196082_o();
        ListNBT items = bundleTag.func_150295_c("bundle_items", 10);
        items.clear();
        bundleTag.func_218657_a("bundle_items", (INBT)items);
        bundle.func_77982_d(bundleTag);
    }

    public static int getBundleItemsCount(ItemStack bundle) {
        return Objects.requireNonNull(BundleItemUtils.getItemsFromBundle(bundle)).stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    public static List<ItemStack> getItemsFromBundle(ItemStack bundle) {
        if (!BundleItemUtils.isBundle(bundle)) {
            return Collections.emptyList();
        }
        CompoundNBT bundleTag = bundle.func_196082_o();
        ListNBT items = bundleTag.func_150295_c("bundle_items", 10);
        return items.stream().map(x -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)x))).collect(Collectors.toList());
    }

    private static ItemStack getItemStackFor(ItemStack bundle, ItemStack stack) {
        return BundleItemUtils.getItemsFromBundle(bundle).stream().filter(x -> ItemStack.func_77989_b((ItemStack)x, (ItemStack)stack)).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static int getItemStackIndex(ItemStack bundle, ItemStack stack) {
        List<ItemStack> items = BundleItemUtils.getItemsFromBundle(bundle);
        return IntStream.range(0, items.size()).filter(i -> stack.equals((ItemStack)items.get(i), false)).findFirst().orElse(-1);
    }

    private static int getMaxStackSizeForBundleToInsert(ItemStack stack) {
        return Math.max(1, Math.min(stack.func_190916_E(), stack.func_77976_d() / 2));
    }

    private static int getMaxStackSizeForBundle(ItemStack stack) {
        return Math.max(1, stack.func_77976_d() / 2);
    }
}

