/*
 * Decompiled with CFR 0.152.
 */
package mods.coffeespawner.block;

import javax.annotation.Nullable;
import mods.coffeespawner.CoffeeSpawner;
import mods.coffeespawner.tileentity.TileEntityCoffeeMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCoffeeMachine
extends Block
implements EntityBlock {
    private static final VoxelShape BOUNDING_BOX_NORMAL = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape BOUNDING_BOX_PAN = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)17.0, (double)13.0);
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final IntegerProperty MODELID = IntegerProperty.m_61631_((String)"modelid", (int)0, (int)1);
    private final boolean isPanModel;

    public BlockCoffeeMachine(String name, boolean isPanModel) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60913_(0.5f, 5.0f));
        this.isPanModel = isPanModel;
        this.setRegistryName(name);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MODELID, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODELID});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        TileEntityCoffeeMachine tile;
        if (!level.m_5776_() && player != null && (tile = this.getTile(level, pos)) != null) {
            if (tile.hasMug()) {
                this.removeMug(level, pos, tile);
                Containers.m_18992_((Level)level, (double)player.m_20182_().f_82479_, (double)player.m_20182_().f_82480_, (double)player.m_20182_().f_82481_, (ItemStack)new ItemStack((ItemLike)CoffeeSpawner.coffee));
            } else {
                player.m_6352_((Component)new TextComponent(ChatFormatting.DARK_AQUA + "Coffee spawns tomorrow."), Util.f_137441_);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public TileEntityCoffeeMachine getTile(Level level, BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        return tile instanceof TileEntityCoffeeMachine ? (TileEntityCoffeeMachine)tile : null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selection) {
        return BOUNDING_BOX_NORMAL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selection) {
        return this.isPanModel ? BOUNDING_BOX_PAN : BOUNDING_BOX_NORMAL;
    }

    public void spawnMug(Level level, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (level == null || pos == null || tile == null || tile.hasMug()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (state != null && state.m_60734_() instanceof BlockCoffeeMachine) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)MODELID, (Comparable)Integer.valueOf(1)));
            tile.setMug(true);
            tile.m_6596_();
        }
    }

    public void removeMug(Level level, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (level == null || pos == null || tile == null || !tile.hasMug()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (state != null && state.m_60734_() instanceof BlockCoffeeMachine) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)MODELID, (Comparable)Integer.valueOf(0)));
            tile.setMug(false);
            tile.m_6596_();
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityCoffeeMachine(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            BlockEntity tile$temp = t;
            if (tile$temp instanceof TileEntityCoffeeMachine) {
                TileEntityCoffeeMachine tile = (TileEntityCoffeeMachine)tile$temp;
                tile.serverTick();
            }
        };
    }
}

