/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends aoc<wb>
implements apa,
da,
AutoCloseable {
    private static final Logger j = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final brx c = new brx("Demo World", brr.b, false, aoo.c, false, new brq(), brh.a);
    protected final cyd.a d;
    protected final cyh e;
    private final aoz k = new aoz("server", this, x.b());
    private final List<Runnable> l = Lists.newArrayList();
    private final ann m = new ann(x.a, this::ah);
    private ant n = anq.a;
    private final aax o;
    private final aaq p;
    private final un q = new un();
    private final Random r = new Random();
    private final DataFixer s;
    private String t;
    private int u = -1;
    protected final gn.b f;
    private final Map<vj<bru>, aag> v = Maps.newLinkedHashMap();
    private acs w;
    private volatile boolean x = true;
    private boolean y;
    private int z;
    protected final Proxy g;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    @Nullable
    private String E;
    private int F;
    private int G;
    public final long[] h = new long[100];
    @Nullable
    private KeyPair H;
    @Nullable
    private String I;
    private boolean J;
    private String K = "";
    private String L = "";
    private volatile boolean M;
    private long N;
    private boolean O;
    private boolean P;
    private final MinecraftSessionService Q;
    private final GameProfileRepository R;
    private final aco S;
    private long T;
    private final Thread U;
    private long V = x.b();
    private long W;
    private boolean X;
    private boolean Y;
    private final abu Z;
    private final wa aa = new wa(this);
    @Nullable
    private cxx ab;
    private final wd ac = new wd();
    private final vx ad;
    private final aez ae = new aez();
    private boolean af;
    private float ag;
    private final Executor ah;
    @Nullable
    private String ai;
    private vz aj;
    private final cst ak;
    protected final cyk i;

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u26032 = new Thread(() -> ((MinecraftServer)atomicReference.get()).w(), "Server thread");
        \u26032.setUncaughtExceptionHandler((thread, throwable) -> j.error((Object)throwable));
        MinecraftServer \u26033 = (MinecraftServer)function.apply(\u26032);
        atomicReference.set(\u26033);
        \u26032.start();
        return (S)\u26033;
    }

    public MinecraftServer(Thread thread, gn.b b2, cyd.a a2, cyk cyk2, abu abu2, Proxy proxy, DataFixer dataFixer, vz vz2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, aco aco2, aaq aaq2) {
        super("Server");
        this.f = b2;
        this.i = cyk2;
        this.g = proxy;
        this.Z = abu2;
        this.aj = vz2;
        this.Q = minecraftSessionService;
        this.R = gameProfileRepository;
        this.S = aco2;
        this.o = new aax(this);
        this.p = aaq2;
        this.d = a2;
        this.e = a2.b();
        this.s = dataFixer;
        this.ad = new vx(this, vz2.a());
        this.ak = new cst(vz2.h(), a2, dataFixer);
        this.U = thread;
        this.ah = x.f();
    }

    @Override
    private void a(cxz cxz2) {
        ddl ddl2 = cxz2.a(ddl::new, "scoreboard");
        ddl2.a(this.aG());
        this.aG().a(new cxo(ddl2));
    }

    protected abstract boolean d() throws IOException;

    public static void a(cyd.a a2) {
        if (a2.c()) {
            j.info("Converting map!");
            a2.a(new afk(){
                private long a = x.b();

                @Override
                public void a(nr nr2) {
                }

                @Override
                public void b(nr nr2) {
                }

                @Override
                public void a(int n2) {
                    if (x.b() - this.a >= 1000L) {
                        this.a = x.b();
                        j.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(nr nr2) {
                }
            });
        }
    }

    protected void l_() {
        this.r();
        this.i.a(this.getServerModName(), this.o().isPresent());
        aap aap2 = this.p.create(11);
        this.a(aap2);
        this.q();
        this.b(aap2);
    }

    protected void q() {
    }

    @Override
    protected void a(aap aap2) {
        cfv \u26039;
        cyj cyj2 = this.i.H();
        cht \u26032 = this.i.A();
        boolean \u26033 = \u26032.g();
        long \u26034 = \u26032.a();
        long \u26035 = bsu.a(\u26034);
        ImmutableList \u26036 = ImmutableList.of((Object)new chr(), (Object)new chq(), (Object)new bfc(), (Object)new azj(), (Object)new bfn(cyj2));
        gi<chb> \u26037 = \u26032.d();
        chb \u26038 = \u26037.a(chb.b);
        if (\u26038 == null) {
            cha cha2 = this.f.a().d(cha.f);
            \u26039 = cht.a(this.f.b(gm.ay), this.f.b(gm.ar), new Random().nextLong());
        } else {
            cha2 = \u26038.b();
            \u26039 = \u26038.c();
        }
        aag aag2 = new aag(this, this.ah, this.d, cyj2, bru.g, cha2, aap2, \u26039, \u26033, \u26035, (List<brg>)\u26036, true);
        this.v.put(bru.g, aag2);
        cxz \u260310 = aag2.s();
        this.a(\u260310);
        this.ab = new cxx(\u260310);
        cfr \u260311 = aag2.f();
        \u260311.a(cyj2.r());
        if (!cyj2.p()) {
            try {
                MinecraftServer.a(aag2, cyj2, \u26032.c(), \u26033, true);
                cyj2.c(true);
                if (\u26033) {
                    this.a(this.i);
                }
            }
            catch (Throwable throwable) {
                l l2 = l.a(throwable, "Exception initializing level");
                try {
                    aag2.a(l2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new u(l2);
            }
            cyj2.c(true);
        }
        this.ad().a(aag2);
        if (this.i.E() != null) {
            this.aL().a(this.i.E());
        }
        for (Map.Entry<vj<chb>, chb> entry : \u26037.d()) {
            vj<chb> vj2 = entry.getKey();
            if (vj2 == chb.b) continue;
            vj<bru> \u260312 = vj.a(gm.L, vj2.a());
            cha \u260313 = entry.getValue().b();
            cfv \u260314 = entry.getValue().c();
            cxy \u260315 = new cxy(this.i, cyj2);
            aag \u260316 = new aag(this, this.ah, this.d, \u260315, \u260312, \u260313, aap2, \u260314, \u26033, \u26035, (List<brg>)ImmutableList.of(), false);
            \u260311.a(new cfp.a(\u260316.f()));
            this.v.put(\u260312, \u260316);
        }
    }

    private static void a(aag aag2, cyj cyj22, boolean bl22, boolean bl3, boolean bl4) {
        boolean bl22;
        cyj cyj22;
        cfv cfv2 = aag2.i().g();
        if (!bl4) {
            cyj22.a(fx.b.b(cfv2.c()), 0.0f);
            return;
        }
        if (bl3) {
            cyj22.a(fx.b.b(), 0.0f);
            return;
        }
        bsv \u26032 = cfv2.d();
        Random \u26033 = new Random(aag2.C());
        fx \u26034 = \u26032.a(0, aag2.t_(), 0, 256, bss2 -> bss2.b().b(), \u26033);
        bra bra2 = \u2603 = \u26034 == null ? new bra(0, 0) : new bra(\u26034);
        if (\u26034 == null) {
            j.warn("Unable to find spawn biome");
        }
        boolean \u26035 = false;
        for (bul bul2 : aeb.V.b()) {
            if (!\u26032.c().contains(bul2.n())) continue;
            \u26035 = true;
            break;
        }
        cyj22.a(\u2603.l().b(8, cfv2.c(), 8), 0.0f);
        int \u26036 = 0;
        int \u26037 = 0;
        int \u26038 = 0;
        int \u26039 = -1;
        int \u260310 = 32;
        for (int i2 = 0; i2 < 1024; ++i2) {
            if (\u26036 > -16 && \u26036 <= 16 && \u26037 > -16 && \u26037 <= 16 && (\u2603 = aab.a(aag2, new bra(\u2603.b + \u26036, \u2603.c + \u26037), \u26035)) != null) {
                cyj22.a(\u2603, 0.0f);
                break;
            }
            if (\u26036 == \u26037 || \u26036 < 0 && \u26036 == -\u26037 || \u26036 > 0 && \u26036 == 1 - \u26037) {
                \u2603 = \u26038;
                \u26038 = -\u26039;
                \u26039 = \u2603;
            }
            \u26036 += \u26038;
            \u26037 += \u26039;
        }
        if (bl22) {
            cis<?, ?> cis2 = kh.U;
            cis2.a(aag2, cfv2, aag2.t, new fx(cyj22.a(), cyj22.b(), cyj22.c()));
        }
    }

    @Override
    private void a(cyk cyk2) {
        cyk2.a(aoo.a);
        cyk2.d(true);
        cyj cyj2 = cyk2.H();
        cyj2.b(false);
        cyj2.a(false);
        cyj2.a(1000000000);
        cyj2.b(6000L);
        cyj2.a(brr.e);
    }

    private void b(aap aap2) {
        aag aag2 = this.E();
        j.info("Preparing start region for dimension {}", (Object)aag2.X().a());
        fx \u26032 = aag2.u();
        aap2.a(new bra(\u26032));
        aae \u26033 = aag2.i();
        \u26033.a().a(500);
        this.V = x.b();
        \u26033.a(aal.a, new bra(\u26032), 11, afu.a);
        while (\u26033.b() != 441) {
            this.V = x.b() + 10L;
            this.x();
        }
        this.V = x.b() + 10L;
        this.x();
        for (aag aag3 : this.v.values()) {
            brp brp2 = aag3.s().b(brp::new, "chunks");
            if (brp2 == null) continue;
            LongIterator \u26034 = brp2.a().iterator();
            while (\u26034.hasNext()) {
                long l2 = \u26034.nextLong();
                bra \u26035 = new bra(l2);
                aag3.i().a(\u26035, true);
            }
        }
        this.V = x.b() + 10L;
        this.x();
        aap2.b();
        \u26033.a().a(5);
        this.bb();
    }

    protected void r() {
        File file = this.d.a(cyb.h).toFile();
        if (file.isFile()) {
            String string = this.d.a();
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException \u26032) {
                j.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public brr s() {
        return this.i.m();
    }

    public boolean f() {
        return this.i.n();
    }

    public abstract int g();

    public abstract int h();

    public abstract boolean i();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (aag aag2 : this.G()) {
            if (!bl2) {
                j.info("Saving chunks for level '{}'/{}", (Object)aag2, (Object)aag2.X().a());
            }
            aag2.a(null, bl3, aag2.c && !bl4);
            bl5 = true;
        }
        aag aag2 = this.E();
        cyj cyj2 = this.i.H();
        cyj2.a(aag2.f().t());
        this.i.b(this.aL().c());
        this.d.a(this.f, this.i, this.ad().q());
        return bl5;
    }

    @Override
    public void close() {
        this.t();
    }

    protected void t() {
        j.info("Stopping server");
        if (this.ae() != null) {
            this.ae().b();
        }
        if (this.w != null) {
            j.info("Saving players");
            this.w.h();
            this.w.r();
        }
        j.info("Saving worlds");
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            aag2.c = false;
        }
        this.a(false, true, false);
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            try {
                aag2.close();
            }
            catch (IOException iOException) {
                j.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
        this.aj.close();
        try {
            this.d.close();
        }
        catch (IOException iOException) {
            j.error("Failed to unlock level {}", (Object)this.d.a(), (Object)iOException);
        }
    }

    public String u() {
        return this.t;
    }

    public void a_(String string) {
        this.t = string;
    }

    public boolean v() {
        return this.x;
    }

    @Override
    public void a(boolean bl2) {
        this.x = false;
        if (bl2) {
            try {
                this.U.join();
            }
            catch (InterruptedException interruptedException) {
                j.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void w() {
        try {
            if (this.d()) {
                this.V = x.b();
                this.q.a(new oe(this.E));
                this.q.a(new un.c(w.a().getName(), w.a().getProtocolVersion()));
                this.a(this.q);
                while (this.x) {
                    long l2 = x.b() - this.V;
                    if (l2 > 2000L && this.V - this.N >= 15000L) {
                        \u2603 = l2 / 50L;
                        j.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.V += \u2603 * 50L;
                        this.N = this.V;
                    }
                    this.V += 50L;
                    anw \u26032 = anw.a("Server");
                    this.a(\u26032);
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aZ);
                    this.n.b("nextTickWait");
                    this.X = true;
                    this.W = Math.max(x.b() + 50L, this.V);
                    this.x();
                    this.n.c();
                    this.n.b();
                    this.b(\u26032);
                    this.M = true;
                }
            } else {
                this.a((l)null);
            }
        }
        catch (Throwable throwable) {
            j.error("Encountered an unexpected exception", throwable);
            l l3 = throwable instanceof u ? this.b(((u)throwable).a()) : this.b(new l("Exception in server tick loop", throwable));
            File \u26033 = new File(new File(this.B(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (l3.a(\u26033)) {
                j.error("This crash report has been saved to: {}", (Object)\u26033.getAbsolutePath());
            } else {
                j.error("We were unable to save this crash report to disk.");
            }
            this.a(l3);
        }
        finally {
            try {
                this.y = true;
                this.t();
            }
            catch (Throwable \u26034) {
                j.error("Exception stopping the server", \u26034);
            }
            finally {
                this.e();
            }
        }
    }

    private boolean aZ() {
        return this.bm() || x.b() < (this.X ? this.W : this.V);
    }

    protected void x() {
        this.bk();
        this.c(() -> !this.aZ());
    }

    protected wb a(Runnable runnable) {
        return new wb(this.z, runnable);
    }

    protected boolean a(wb wb2) {
        return wb2.a() + 3 < this.z || this.aZ();
    }

    @Override
    public boolean y() {
        boolean bl2;
        this.X = bl2 = this.ba();
        return bl2;
    }

    private boolean ba() {
        if (super.y()) {
            return true;
        }
        if (this.aZ()) {
            for (aag aag2 : this.G()) {
                if (!aag2.i().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(wb wb2) {
        this.aP().c("runTask");
        super.c(wb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void a(un un2) {
        File file = this.c("server-icon.png");
        if (!file.exists()) {
            file = this.d.f();
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                un2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                j.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean z() {
        this.Y = this.Y || this.A().isFile();
        return this.Y;
    }

    public File A() {
        return this.d.f();
    }

    public File B() {
        return new File(".");
    }

    @Override
    protected void a(l l2) {
    }

    protected void e() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = x.c();
        ++this.z;
        this.b(booleanSupplier);
        if (l2 - this.T >= 5000000000L) {
            this.T = l2;
            this.q.a(new un.a(this.J(), this.I()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.I(), 12)];
            int \u26032 = afj.a(this.r, 0, this.I() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.w.s().get(\u26032 + i2).ez();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.z % 6000 == 0) {
            j.debug("Autosave started");
            this.n.a("save");
            this.w.h();
            this.a(true, false, false);
            this.n.c();
            j.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.z > 100) {
            this.k.a();
        }
        if (this.z % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = x.c() - l2;
        this.h[this.z % 100] = l3;
        \u2603 = l3;
        this.ag = this.ag * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = x.c();
        this.ae.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aA().d();
        this.n.b("levels");
        for (aag aag2 : this.G()) {
            this.n.a(() -> aag2 + " " + aag2.X().a());
            if (this.z % 20 == 0) {
                this.n.a("timeSync");
                this.w.a(new rk(aag2.S(), aag2.T(), aag2.U().b(brq.j)), aag2.X());
                this.n.c();
            }
            this.n.a("tick");
            try {
                aag2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                l l2 = l.a(throwable, "Exception ticking world");
                aag2.a(l2);
                throw new u(l2);
            }
            this.n.c();
            this.n.c();
        }
        this.n.b("connection");
        this.ae().c();
        this.n.b("players");
        this.w.d();
        if (w.d) {
            ll.a.b();
        }
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.l.get(i2).run();
        }
        this.n.c();
    }

    public boolean C() {
        return true;
    }

    public void b(Runnable runnable) {
        this.l.add(runnable);
    }

    protected void b(String string) {
        this.ai = string;
    }

    public boolean D() {
        return !this.U.isAlive();
    }

    public File c(String string) {
        return new File(this.B(), string);
    }

    public final aag E() {
        return this.v.get(bru.g);
    }

    @Nullable
    public aag a(vj<bru> vj2) {
        return this.v.get(vj2);
    }

    public Set<vj<bru>> F() {
        return this.v.keySet();
    }

    public Iterable<aag> G() {
        return this.v.values();
    }

    public String H() {
        return w.a().getName();
    }

    public int I() {
        return this.w.m();
    }

    public int J() {
        return this.w.n();
    }

    public String[] K() {
        return this.w.e();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public l b(l l2) {
        if (this.w != null) {
            l2.g().a("Player Count", () -> this.w.m() + " / " + this.w.n() + "; " + this.w.s());
        }
        l2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (abs abs2 : this.Z.e()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(abs2.e());
                if (abs2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.ai != null) {
            l2.g().a("Server Id", () -> this.ai);
        }
        return l2;
    }

    public abstract Optional<String> o();

    @Override
    public void a(nr nr2, UUID uUID) {
        j.info(nr2.getString());
    }

    public KeyPair L() {
        return this.H;
    }

    public int M() {
        return this.u;
    }

    @Override
    public void a(int n2) {
        this.u = n2;
    }

    public String N() {
        return this.I;
    }

    public void d(String string) {
        this.I = string;
    }

    public boolean O() {
        return this.I != null;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(aoo aoo2, boolean bl2) {
        if (!bl2 && this.i.t()) {
            return;
        }
        this.i.a(this.i.n() ? aoo.d : aoo2);
        this.bb();
        this.ad().s().forEach(this::a);
    }

    public int b(int n2) {
        return n2;
    }

    private void bb() {
        for (aag aag2 : this.G()) {
            aag2.b(this.P(), this.W());
        }
    }

    public void b(boolean bl2) {
        this.i.d(bl2);
        this.ad().s().forEach(this::a);
    }

    @Override
    private void a(aah aah2) {
        cya cya2 = aah2.u().h();
        aah2.b.a(new pa(cya2.s(), cya2.t()));
    }

    protected boolean P() {
        return this.i.s() != aoo.a;
    }

    public boolean Q() {
        return this.J;
    }

    @Override
    public void c(boolean bl2) {
        this.J = bl2;
    }

    public String R() {
        return this.K;
    }

    public String S() {
        return this.L;
    }

    public void a(String string, String string2) {
        this.K = string;
        this.L = string2;
    }

    @Override
    public void a(aoz aoz22) {
        aoz aoz22;
        aoz22.a("whitelist_enabled", false);
        aoz22.a("whitelist_count", 0);
        if (this.w != null) {
            aoz22.a("players_current", this.I());
            aoz22.a("players_max", this.J());
            aoz22.a("players_seen", this.e.a().length);
        }
        aoz22.a("uses_auth", this.A);
        aoz22.a("gui_state", this.ag() ? "enabled" : "disabled");
        aoz22.a("run_time", (x.b() - aoz22.g()) / 60L * 1000L);
        aoz22.a("avg_tick_ms", (int)(afj.a(this.h) * 1.0E-6));
        int n2 = 0;
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            aoz22.a("world[" + n2 + "][dimension]", aag2.X().a());
            aoz22.a("world[" + n2 + "][mode]", (Object)this.i.m());
            aoz22.a("world[" + n2 + "][difficulty]", (Object)aag2.ac());
            aoz22.a("world[" + n2 + "][hardcore]", this.i.n());
            aoz22.a("world[" + n2 + "][height]", this.F);
            aoz22.a("world[" + n2 + "][chunks_loaded]", aag2.i().h());
            ++n2;
        }
        aoz22.a("worlds", n2);
    }

    public abstract boolean j();

    public abstract int k();

    public boolean U() {
        return this.A;
    }

    public void d(boolean bl2) {
        this.A = bl2;
    }

    public boolean V() {
        return this.B;
    }

    public void e(boolean bl2) {
        this.B = bl2;
    }

    public boolean W() {
        return true;
    }

    public boolean X() {
        return true;
    }

    public abstract boolean l();

    public boolean Y() {
        return this.C;
    }

    public void f(boolean bl2) {
        this.C = bl2;
    }

    public boolean Z() {
        return this.D;
    }

    public void g(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean m();

    public String aa() {
        return this.E;
    }

    public void e(String string) {
        this.E = string;
    }

    public int ab() {
        return this.F;
    }

    @Override
    public void c(int n2) {
        this.F = n2;
    }

    public boolean ac() {
        return this.y;
    }

    public acs ad() {
        return this.w;
    }

    @Override
    public void a(acs acs2) {
        this.w = acs2;
    }

    public abstract boolean n();

    @Override
    public void a(brr brr2) {
        this.i.a(brr2);
    }

    @Nullable
    public aax ae() {
        return this.o;
    }

    public boolean af() {
        return this.M;
    }

    public boolean ag() {
        return false;
    }

    public abstract boolean a(brr var1, boolean var2, int var3);

    public int ah() {
        return this.z;
    }

    public aoz ai() {
        return this.k;
    }

    public int aj() {
        return 16;
    }

    public boolean a(aag aag2, fx fx2, bft bft2) {
        return false;
    }

    @Override
    public void h(boolean bl2) {
        this.P = bl2;
    }

    public boolean ak() {
        return this.P;
    }

    public boolean al() {
        return true;
    }

    public int an() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    public MinecraftSessionService ao() {
        return this.Q;
    }

    public GameProfileRepository ap() {
        return this.R;
    }

    public aco aq() {
        return this.S;
    }

    public un ar() {
        return this.q;
    }

    public void as() {
        this.T = 0L;
    }

    public int at() {
        return 29999984;
    }

    @Override
    public boolean au() {
        return super.au() && !this.ac();
    }

    @Override
    public Thread av() {
        return this.U;
    }

    public int aw() {
        return 256;
    }

    public long ax() {
        return this.V;
    }

    public DataFixer ay() {
        return this.s;
    }

    public int a(@Nullable aag aag2) {
        if (aag2 != null) {
            return aag2.U().c(brq.q);
        }
        return 10;
    }

    public vv az() {
        return this.aj.g();
    }

    public vx aA() {
        return this.ad;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.Z::a).filter(Objects::nonNull).map(abs::d).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> vz.a((List<abh>)immutableList, this.j() ? dc.a.b : dc.a.c, this.h(), this.ah, this))).thenAcceptAsync(vz2 -> {
            this.aj.close();
            this.aj = vz2;
            this.Z.a(collection);
            this.i.a(MinecraftServer.a(this.Z));
            vz2.i();
            this.ad().h();
            this.ad().t();
            this.ad.a(this.aj.a());
            this.ak.a(this.aj.h());
        }, (Executor)this);
        if (this.bg()) {
            this.c(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static brh a(abu abu22, brh brh2, boolean bl2) {
        abu22.a();
        if (bl2) {
            abu22.a(Collections.singleton("vanilla"));
            return new brh((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : brh2.a()) {
            if (abu22.b(string)) {
                linkedHashSet.add(string);
                continue;
            }
            j.warn("Missing data pack {}", (Object)string);
        }
        for (abs abs2 : abu22.c()) {
            String string = abs2.e();
            if (brh2.b().contains(string) || linkedHashSet.contains(string)) continue;
            j.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            j.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        abu22.a(linkedHashSet);
        return MinecraftServer.a(abu22);
    }

    private static brh a(abu abu2) {
        Collection<String> collection = abu2.d();
        ImmutableList \u26032 = ImmutableList.copyOf(collection);
        List \u26033 = (List)abu2.b().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new brh((List<String>)\u26032, \u26033);
    }

    @Override
    public void a(db db2) {
        if (!this.aM()) {
            return;
        }
        acs acs2 = db2.j().ad();
        acz \u26032 = acs2.i();
        ArrayList \u26033 = Lists.newArrayList(acs2.s());
        for (aah aah2 : \u26033) {
            if (\u26032.a(aah2.ez())) continue;
            aah2.b.b(new of("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public abu aB() {
        return this.Z;
    }

    public dc aC() {
        return this.aj.f();
    }

    public db aD() {
        aag aag2 = this.E();
        return new db(this, aag2 == null ? dck.a : dck.b(aag2.u()), dcj.a, aag2, 4, "Server", new oe("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public boo aE() {
        return this.aj.e();
    }

    public ael aF() {
        return this.aj.d();
    }

    public wa aG() {
        return this.aa;
    }

    public cxx aH() {
        if (this.ab == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.ab;
    }

    public cyw aI() {
        return this.aj.c();
    }

    public cyx aJ() {
        return this.aj.b();
    }

    public brq aK() {
        return this.E().U();
    }

    public wd aL() {
        return this.ac;
    }

    public boolean aM() {
        return this.af;
    }

    public void i(boolean bl2) {
        this.af = bl2;
    }

    public float aN() {
        return this.ag;
    }

    public int b(GameProfile gameProfile) {
        if (this.ad().h(gameProfile)) {
            acu acu2 = (acu)this.ad().k().b(gameProfile);
            if (acu2 != null) {
                return acu2.a();
            }
            if (this.a(gameProfile)) {
                return 4;
            }
            if (this.O()) {
                return this.ad().u() ? 4 : 0;
            }
            return this.g();
        }
        return 0;
    }

    public aez aO() {
        return this.ae;
    }

    public ant aP() {
        return this.n;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<vj<bru>, aag> entry : this.v.entrySet()) {
            vk vk2 = entry.getKey().a();
            Path \u26032 = \u2603.resolve(vk2.b()).resolve(vk2.a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().a(\u26032);
        }
        this.d(path.resolve("gamerules.txt"));
        this.e(path.resolve("classpath.txt"));
        this.c(path.resolve("example_crash.txt"));
        this.b(path.resolve("stats.txt"));
        this.f(path.resolve("threads.txt"));
    }

    private void b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.bh()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aN())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.h)));
            bufferedWriter.write(String.format("queue: %s\n", x.f()));
        }
    }

    @Override
    private void c(Path path) throws IOException {
        l l2 = new l("Server dump", new Exception("dummy"));
        this.b(l2);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(l2.e());
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final brq \u26032 = this.aK();
            brq.a(new brq.c(){

                @Override
                public <T extends brq.g<T>> void a(brq.e<T> e2, brq.f<T> f2) {
                    arrayList.add(String.format("%s=%s\n", e2.a(), ((brq.g)\u26032.a(e2)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    @Override
    private void a(@Nullable anw anw2) {
        if (this.O) {
            this.O = false;
            this.m.c();
        }
        this.n = anw.a(this.m.d(), anw2);
    }

    private void b(@Nullable anw anw2) {
        if (anw2 != null) {
            anw2.b();
        }
        this.n = this.m.d();
    }

    public boolean aR() {
        return this.m.a();
    }

    public void aS() {
        this.O = true;
    }

    public ans aT() {
        ans ans2 = this.m.e();
        this.m.b();
        return ans2;
    }

    public Path a(cyb cyb2) {
        return this.d.a(cyb2);
    }

    public boolean aU() {
        return true;
    }

    public cst aV() {
        return this.ak;
    }

    public cyk aW() {
        return this.i;
    }

    public gn aX() {
        return this.f;
    }

    @Override
    public /* synthetic */ void c(Runnable runnable) {
        this.b((wb)runnable);
    }

    @Override
    public /* synthetic */ boolean d(Runnable runnable) {
        return this.a((wb)runnable);
    }

    @Override
    public /* synthetic */ Runnable e(Runnable runnable) {
        return this.a(runnable);
    }
}

