/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.enitity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.class_898;

@Environment(value=EnvType.CLIENT)
public class ChainKnotEntityRenderer
extends class_897<ChainKnotEntity> {
    private static final class_2960 TEXTURE = Helper.identifier("textures/entity/chain_knot.png");
    private final ChainKnotEntityModel<ChainKnotEntity> model = new ChainKnotEntityModel();

    public ChainKnotEntityRenderer(class_898 entityRenderDispatcher) {
        super(entityRenderDispatcher);
    }

    public void render(ChainKnotEntity chainKnotEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        super.method_3936((class_1297)chainKnotEntity, f, g, matrixStack, vertexConsumerProvider, i);
        matrixStack.method_22903();
        matrixStack.method_22905(-0.9f, -0.9f, 0.9f);
        this.model.method_2819(chainKnotEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(this.model.method_23500(TEXTURE));
        this.model.method_2828(matrixStack, vertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.method_22909();
        ArrayList<class_1297> entities = chainKnotEntity.getHoldingEntities();
        for (class_1297 entity : entities) {
            this.createChainLine(chainKnotEntity, g, matrixStack, vertexConsumerProvider, entity);
        }
    }

    public boolean shouldRender(ChainKnotEntity entity, class_4604 frustum, double x, double y, double z) {
        boolean should = entity.getHoldingEntities().stream().anyMatch(entity1 -> {
            if (entity1 instanceof ChainKnotEntity) {
                return super.method_3933((class_1297)((ChainKnotEntity)((Object)entity1)), frustum, x, y, z);
            }
            return entity1 instanceof class_1657;
        });
        return super.method_3933((class_1297)entity, frustum, x, y, z) || should;
    }

    public class_2960 getTexture(ChainKnotEntity chainKnotEntity) {
        return TEXTURE;
    }

    private void createChainLine(ChainKnotEntity fromEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_1297 chainOrPlayerEntity) {
        float t;
        float s;
        float r;
        matrixStack.method_22903();
        double d = class_3532.method_16439((float)(f * 0.5f), (float)chainOrPlayerEntity.field_6031, (float)chainOrPlayerEntity.field_5982) * ((float)Math.PI / 180);
        double e = class_3532.method_16439((float)(f * 0.5f), (float)chainOrPlayerEntity.field_5965, (float)chainOrPlayerEntity.field_6004) * ((float)Math.PI / 180);
        double g = Math.cos(d);
        double h = Math.sin(d);
        double i = Math.sin(e);
        if (chainOrPlayerEntity instanceof class_1530) {
            g = 0.0;
            h = 0.0;
            double k = class_3532.method_16436((double)f, (double)chainOrPlayerEntity.field_6014, (double)chainOrPlayerEntity.method_23317());
            double l = class_3532.method_16436((double)f, (double)chainOrPlayerEntity.field_6036, (double)chainOrPlayerEntity.method_23318());
            double m = class_3532.method_16436((double)f, (double)chainOrPlayerEntity.field_5969, (double)chainOrPlayerEntity.method_23321());
            double o = class_3532.method_16436((double)f, (double)fromEntity.field_6014, (double)fromEntity.method_23317());
            double p = class_3532.method_16436((double)f, (double)fromEntity.field_6036, (double)fromEntity.method_23318());
            double q = class_3532.method_16436((double)f, (double)fromEntity.field_5969, (double)fromEntity.method_23321());
            matrixStack.method_22904(g, (double)0.3f, h);
            r = (float)(k - o);
            s = (float)(l - p);
            t = (float)(m - q);
        } else {
            double j = Math.cos(e);
            double k = class_3532.method_16436((double)f, (double)chainOrPlayerEntity.field_6014, (double)chainOrPlayerEntity.method_23317()) - g * 0.7 - h * 0.5 * j;
            double l = class_3532.method_16436((double)f, (double)(chainOrPlayerEntity.field_6036 + (double)chainOrPlayerEntity.method_5751() * 0.7), (double)(chainOrPlayerEntity.method_23318() + (double)chainOrPlayerEntity.method_5751() * 0.7)) - i * 0.5 - 0.5;
            double m = class_3532.method_16436((double)f, (double)chainOrPlayerEntity.field_5969, (double)chainOrPlayerEntity.method_23321()) - h * 0.7 + g * 0.5 * j;
            double o = class_3532.method_16436((double)f, (double)fromEntity.field_6014, (double)fromEntity.method_23317());
            double p = class_3532.method_16436((double)f, (double)fromEntity.field_6036, (double)fromEntity.method_23318()) + (double)0.3f;
            double q = class_3532.method_16436((double)f, (double)fromEntity.field_5969, (double)fromEntity.method_23321());
            matrixStack.method_22904(0.0, (double)0.3f, 0.0);
            r = (float)(k - o);
            s = (float)(l - p);
            t = (float)(m - q);
        }
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23587());
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        float v = class_3532.method_22858((float)(r * r + t * t)) * 0.025f / 2.0f;
        float xOffset = t * v;
        float zOffset = r * v;
        class_2338 zzz = new class_2338(fromEntity.method_5836(f));
        int y = this.method_24087((class_1297)fromEntity, zzz);
        int z = chainOrPlayerEntity.method_5809() ? 15 : chainOrPlayerEntity.field_6002.method_8314(class_1944.field_9282, new class_2338(chainOrPlayerEntity.method_5836(f)));
        int aa = fromEntity.field_6002.method_8314(class_1944.field_9284, zzz);
        int ab = fromEntity.field_6002.method_8314(class_1944.field_9284, new class_2338(chainOrPlayerEntity.method_5836(f)));
        float distance = chainOrPlayerEntity.method_5739((class_1297)fromEntity);
        ChainKnotEntityRenderer.lineBuilder(distance, vertexConsumer, matrix4f, r, s, t, y, z, aa, ab, xOffset, zOffset);
        matrixStack.method_22909();
    }

    private static float[] rotator(double x, double y, double z) {
        double x2 = x * x;
        double z2 = z * z;
        double zx = Math.sqrt(x2 + z2);
        double arc1 = Math.atan2(y, zx);
        double arc2 = Math.atan2(x, z);
        double d = Math.sin(arc1) * (double)0.0125f;
        float y_new = (float)(Math.cos(arc1) * (double)0.0125f);
        float z_new = (float)(Math.cos(arc2) * d);
        float x_new = (float)(Math.sin(arc2) * d);
        float v = 0.0f;
        if (zx == 0.0) {
            x_new = z_new;
            v = 1.0f;
        }
        return new float[]{x_new, y_new, z_new, v};
    }

    private static void lineBuilder(float distance, class_4588 vertexConsumer, class_1159 matrix4f, float cordX, float cordY, float cordZ, int i, int j, int k, int l, float xOffset, float zOffset) {
        List<Integer> mPatternA = Arrays.asList(1, 3, 6, 9, 12, 14);
        List<Integer> stbPatternA = Arrays.asList(1, 12);
        List<Integer> ltbPatternA = Collections.singletonList(6);
        List<Integer> stbPatternB = Arrays.asList(0, 14);
        List<Integer> ltbPatternB = Arrays.asList(3, 9);
        int length = (int)Math.floor(distance * 24.0f);
        for (int p = 0; p < length; ++p) {
            int T;
            float s = (float)l / (float)(length - 1);
            int t = (int)class_3532.method_16439((float)s, (float)i, (float)j);
            int u = (int)class_3532.method_16439((float)s, (float)k, (float)l);
            int pack = class_765.method_23687((int)t, (int)u);
            if (mPatternA.contains(p % 16)) {
                ChainKnotEntityRenderer.middle(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p, false, xOffset, zOffset, false);
                ChainKnotEntityRenderer.middle(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1, true, xOffset, zOffset, false);
                ChainKnotEntityRenderer.middle(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p, false, xOffset, zOffset, true);
                ChainKnotEntityRenderer.middle(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1, true, xOffset, zOffset, true);
            }
            if (stbPatternA.contains(p % 16)) {
                for (T = 0; T < 3; ++T) {
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, false);
                }
            }
            if (ltbPatternA.contains(p % 16)) {
                for (T = 0; T < 4; ++T) {
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, false);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, false);
                }
            }
            if (stbPatternB.contains(p % 16)) {
                for (T = 0; T < 2; ++T) {
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, true);
                    ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, true);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, true);
                    ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, true);
                }
            }
            if (!ltbPatternB.contains(p % 16)) continue;
            for (T = 0; T < 4; ++T) {
                ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, true);
                ChainKnotEntityRenderer.top(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, true);
                ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + T, false, xOffset, zOffset, true);
                ChainKnotEntityRenderer.bot(length, vertexConsumer, matrix4f, pack, cordX, cordY, cordZ, length, p + 1 + T, true, xOffset, zOffset, true);
            }
        }
    }

    private static void middle(int V, class_4588 vertexConsumer, class_1159 matrix4f, int i, float cordX, float cordY, float cordZ, int l, int step, boolean bl, float n, float o, boolean shift) {
        double drip = ChainKnotEntityRenderer.drip(step, V);
        float s = (float)step / (float)l;
        float[] rotate = ChainKnotEntityRenderer.rotator(cordX, cordY, cordZ);
        float v1 = 1.0f;
        if (rotate[3] == 1.0f) {
            v1 *= -1.0f;
        }
        float t = cordX * s;
        float u = cordY * s;
        float v = cordZ * s;
        float x1 = t + rotate[0] + n;
        float y1 = u + 0.0125f - rotate[1];
        float z1 = v + rotate[2] - o;
        float x2 = t - rotate[0] - n;
        float y2 = u + 0.0125f + rotate[1];
        float z2 = v - rotate[2] + o;
        float R = 0.084f;
        float G = 0.084f;
        float B = 0.119f;
        if (shift) {
            R = 0.12f;
            G = 0.12f;
            B = 0.17f;
            x1 = t + rotate[0] * v1 - n;
            z1 = v + rotate[2] + o;
            x2 = t - rotate[0] * v1 + n;
            z2 = v - rotate[2] - o;
        }
        y1 = (float)((double)y1 + drip);
        y2 = (float)((double)y2 + drip);
        ChainKnotEntityRenderer.renderPart(vertexConsumer, matrix4f, i, bl, R, G, B, x1, y1, z1, x2, y2, z2);
    }

    private static void renderPart(class_4588 vertexConsumer, class_1159 matrix4f, int i, boolean bl, float R, float G, float B, float x1, float y1, float z1, float x2, float y2, float z2) {
        if (bl) {
            vertexConsumer.method_22918(matrix4f, x1, y1, z1).method_22915(R, G, B, 1.0f).method_22916(i).method_1344();
        }
        vertexConsumer.method_22918(matrix4f, x2, y2, z2).method_22915(R, G, B, 1.0f).method_22916(i).method_1344();
        if (!bl) {
            vertexConsumer.method_22918(matrix4f, x1, y1, z1).method_22915(R, G, B, 1.0f).method_22916(i).method_1344();
        }
    }

    private static float drip(int x, float V) {
        float c = 0.6f;
        float b = -c / V;
        float a = c / (V * V);
        return a * (float)(x * x) + b * (float)x;
    }

    private static void top(int V, class_4588 vertexConsumer, class_1159 matrix4f, int i, float cordX, float cordY, float cordZ, int l, int step, boolean bl, float n, float o, boolean shift) {
        double drip = ChainKnotEntityRenderer.drip(step, V);
        float s = (float)step / (float)l;
        float[] rotate = ChainKnotEntityRenderer.rotator(cordX, cordY, cordZ);
        float v1 = 1.0f;
        if (rotate[3] == 1.0f) {
            v1 *= -1.0f;
        }
        float t = cordX * s;
        float u = cordY * s;
        float v = cordZ * s;
        float x1 = t - rotate[0] + n;
        float y1 = u + 0.0125f + rotate[1];
        float z1 = v - rotate[2] - o;
        float x2 = t - (rotate[0] - n) * 3.0f;
        float y2 = u + 0.0125f + rotate[1] * 3.0f;
        float z2 = v - (rotate[2] + o) * 3.0f;
        float R = 0.16f;
        float G = 0.17f;
        float B = 0.21f;
        if (shift) {
            R *= 0.8f;
            G *= 0.8f;
            B *= 0.8f;
            x1 = t - rotate[0] * v1 - n;
            z1 = v - rotate[2] + o;
            x2 = t - (rotate[0] * v1 + n) * 3.0f;
            z2 = v - (rotate[2] - o) * 3.0f;
        }
        y1 = (float)((double)y1 + drip);
        y2 = (float)((double)y2 + drip);
        ChainKnotEntityRenderer.renderPart(vertexConsumer, matrix4f, i, bl, R, G, B, x1, y1, z1, x2, y2, z2);
    }

    private static void bot(int V, class_4588 vertexConsumer, class_1159 matrix4f, int i, float cordX, float cordY, float cordZ, int l, int step, boolean bl, float n, float o, boolean shift) {
        double drip = ChainKnotEntityRenderer.drip(step, V);
        float s = (float)step / (float)l;
        float[] rotate = ChainKnotEntityRenderer.rotator(cordX, cordY, cordZ);
        float v1 = 1.0f;
        if (rotate[3] == 1.0f) {
            v1 *= -1.0f;
        }
        float t = cordX * s;
        float u = cordY * s;
        float v = cordZ * s;
        float x1 = t + (rotate[0] - n) * 3.0f;
        float y1 = u + 0.0125f - rotate[1] * 3.0f;
        float z1 = v + (rotate[2] + o) * 3.0f;
        float x2 = t + rotate[0] - n;
        float y2 = u + 0.0125f - rotate[1];
        float z2 = v + rotate[2] + o;
        float R = 0.16f;
        float G = 0.17f;
        float B = 0.21f;
        if (shift) {
            R *= 0.8f;
            G *= 0.8f;
            B *= 0.8f;
            x1 = t + (rotate[0] * v1 + n) * 3.0f;
            z1 = v + (rotate[2] - o) * 3.0f;
            x2 = t + rotate[0] * v1 + n;
            z2 = v + rotate[2] - o;
        }
        y1 = (float)((double)y1 + drip);
        y2 = (float)((double)y2 + drip);
        ChainKnotEntityRenderer.renderPart(vertexConsumer, matrix4f, i, bl, R, G, B, x1, y1, z1, x2, y2, z2);
    }
}

