/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.enitity;

import com.github.legoatoom.connectiblechains.enitity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.util.NetworkingPackages;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainKnotEntity
extends class_1530 {
    public static final double MAX_RANGE = 7.0;
    private final Map<Integer, class_1297> holdingEntities = new HashMap<Integer, class_1297>();
    public int holdersCount = 0;
    private class_2499 chainTags;

    public ChainKnotEntity(class_1299<? extends ChainKnotEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ChainKnotEntity(class_1937 world, class_2338 pos) {
        super(ModEntityTypes.CHAIN_KNOT, world, pos);
        this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        this.method_5857(new class_238(this.method_23317() - 0.1875, this.method_23318() - 0.25 + 0.125, this.method_23321() - 0.1875, this.method_23317() + 0.1875, this.method_23318() + 0.25 + 0.125, this.method_23321() + 0.1875));
        this.field_5983 = true;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814((double)class_3532.method_15357((double)x) + 0.5, (double)class_3532.method_15357((double)y) + 0.5, (double)class_3532.method_15357((double)z) + 0.5);
    }

    protected void method_6895() {
        this.method_23327((double)this.field_7100.method_10263() + 0.5, (double)this.field_7100.method_10264() + 0.5, (double)this.field_7100.method_10260() + 0.5);
        this.method_5857(new class_238(this.method_23317() - 0.1875, this.method_23318() - 0.25 + 0.125, this.method_23321() - 0.1875, this.method_23317() + 0.1875, this.method_23318() + 0.25 + 0.125, this.method_23321() + 0.1875));
    }

    public void method_6892(class_2350 facing) {
    }

    public int method_6897() {
        return 9;
    }

    public int method_6891() {
        return 9;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return -0.0625f;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 1024.0;
    }

    public void method_6889(@Nullable class_1297 entity) {
        this.method_5783(class_3417.field_24065, 1.0f, 1.0f);
    }

    public void method_5652(class_2487 tag) {
        boolean b = false;
        class_2499 listTag = new class_2499();
        for (class_1297 entity : this.holdingEntities.values()) {
            if (entity == null) continue;
            class_2487 compoundTag = new class_2487();
            if (entity instanceof class_1657) {
                UUID uuid = entity.method_5667();
                compoundTag.method_25927("UUID", uuid);
                b = true;
            } else if (entity instanceof class_1530) {
                class_2338 blockPos = ((class_1530)entity).method_6896();
                compoundTag.method_10569("X", blockPos.method_10263());
                compoundTag.method_10569("Y", blockPos.method_10264());
                compoundTag.method_10569("Z", blockPos.method_10260());
                b = true;
            }
            listTag.add((Object)compoundTag);
        }
        if (b) {
            tag.method_10566("Chains", (class_2520)listTag);
        } else if (this.chainTags != null && !this.chainTags.isEmpty()) {
            tag.method_10566("Chains", (class_2520)this.chainTags.method_10612());
        }
    }

    public void method_5749(class_2487 tag) {
        if (tag.method_10545("Chains")) {
            this.chainTags = tag.method_10554("Chains", 10);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.method_8608()) {
            this.updateChains();
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.field_6002.field_9236) {
            return class_1269.field_5812;
        }
        boolean bl = false;
        List list = this.field_6002.method_18467(ChainKnotEntity.class, new class_238(this.method_23317() - 7.0, this.method_23318() - 7.0, this.method_23321() - 7.0, this.method_23317() + 7.0, this.method_23318() + 7.0, this.method_23321() + 7.0));
        for (ChainKnotEntity mobEntity2 : list) {
            ArrayList<class_1297> holdings = mobEntity2.getHoldingEntities();
            if (!holdings.contains(player) || holdings.contains((Object)this) || mobEntity2.equals((Object)this)) continue;
            mobEntity2.attachChain((class_1297)this, true, player.method_5628());
            bl = true;
        }
        if (!bl) {
            if (this.getHoldingEntities().contains(player)) {
                this.method_6889(null);
                this.detachChain((class_1297)player, true, false);
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7933(1);
                }
            } else if (player.method_5998(hand).method_7909().equals(class_1802.field_23983)) {
                this.method_6894();
                this.attachChain((class_1297)player, true, 0);
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
            } else {
                this.method_5643(class_1282.method_5532((class_1657)player), 0.0f);
            }
        } else {
            this.method_6894();
        }
        return class_1269.field_21466;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bool = super.method_5643(source, amount);
        ArrayList<class_1297> list = this.getHoldingEntities();
        for (class_1297 entity : list) {
            if (this.field_6002.method_8608()) continue;
            if (entity instanceof ChainKnotEntity && ((ChainKnotEntity)entity).holdersCount <= 1 && ((ChainKnotEntity)entity).getHoldingEntities().isEmpty()) {
                entity.method_5650();
            }
            class_243 middle = ChainKnotEntity.middleOf(this.method_19538(), entity.method_19538());
            class_1542 entity1 = new class_1542(this.field_6002, middle.field_1352, middle.field_1351, middle.field_1350, new class_1799((class_1935)class_1802.field_23983));
            entity1.method_6988();
            this.field_6002.method_8649((class_1297)entity1);
        }
        return bool;
    }

    public boolean method_6888() {
        return this.field_6002.method_8320(this.field_7100).method_26204().method_9525((class_3494)class_3481.field_16584);
    }

    @NotNull
    public static ChainKnotEntity getOrCreate(class_1937 world, class_2338 pos) {
        return ChainKnotEntity.getOrCreate(world, pos, false);
    }

    @Nullable
    public static ChainKnotEntity getOrCreate(class_1937 world, class_2338 pos, Boolean hasToExist) {
        ChainKnotEntity leashKnotEntity;
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        List list = world.method_18467(ChainKnotEntity.class, new class_238((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0));
        Iterator var6 = list.iterator();
        do {
            if (var6.hasNext()) continue;
            if (hasToExist.booleanValue()) {
                return null;
            }
            ChainKnotEntity leashKnotEntity2 = new ChainKnotEntity(world, pos);
            world.method_8649((class_1297)leashKnotEntity2);
            leashKnotEntity2.method_6894();
            return leashKnotEntity2;
        } while ((leashKnotEntity = (ChainKnotEntity)((Object)var6.next())) == null || !leashKnotEntity.method_6896().equals((Object)pos));
        return leashKnotEntity;
    }

    public void method_6894() {
        this.method_5783(class_3417.field_24063, 1.0f, 1.0f);
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this, this.method_5864(), 0, this.method_6896());
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 method_30951(float f) {
        return this.method_30950(f).method_1031(0.0, 0.2, 0.0);
    }

    public ArrayList<class_1297> getHoldingEntities() {
        if (this.field_6002.method_8608()) {
            for (Integer id : this.holdingEntities.keySet()) {
                if (id == 0 || this.holdingEntities.get(id) != null) continue;
                this.holdingEntities.put(id, this.field_6002.method_8469(id.intValue()));
            }
        }
        return new ArrayList<class_1297>(this.holdingEntities.values());
    }

    protected void updateChains() {
        class_1297[] entitySet;
        if (this.chainTags != null) {
            class_2499 copy = this.chainTags.method_10612();
            for (class_2520 tag : copy) {
                assert (tag instanceof class_2487);
                this.deserializeChainTag((class_2487)tag);
            }
        }
        for (class_1297 entity : entitySet = (class_1297[])this.holdingEntities.values().toArray(new class_1297[0]).clone()) {
            if (entity == null || this.method_5805() && entity.method_5805() && !(entity.method_19538().method_1025(this.method_19538()) > 49.0)) continue;
            this.detachChain(entity, true, true);
            this.method_6889(null);
        }
    }

    public void detachChain(class_1297 entity, boolean sendPacket, boolean dropItem) {
        if (entity != null) {
            if (this.holdingEntities.size() <= 1) {
                this.field_5983 = false;
            }
            if (entity instanceof ChainKnotEntity && ((ChainKnotEntity)entity).holdingEntities.isEmpty()) {
                entity.field_5983 = false;
            }
            this.holdingEntities.remove(entity.method_5628());
            if (!this.field_6002.method_8608() && dropItem) {
                class_243 middle = ChainKnotEntity.middleOf(this.method_19538(), entity.method_19538());
                class_1542 entity1 = new class_1542(this.field_6002, middle.field_1352, middle.field_1351, middle.field_1350, new class_1799((class_1935)class_1802.field_23983));
                entity1.method_6988();
                this.field_6002.method_8649((class_1297)entity1);
            }
            if (!this.field_6002.method_8608() && sendPacket && this.field_6002 instanceof class_3218) {
                if (entity instanceof ChainKnotEntity) {
                    --((ChainKnotEntity)entity).holdersCount;
                    if (this.holdersCount <= 0 && this.getHoldingEntities().isEmpty()) {
                        this.method_5650();
                    }
                }
                this.sendDetachChainPacket(entity.method_5628());
            }
        }
    }

    public void attachChain(class_1297 entity, boolean sendPacket, int fromPlayerEntityId) {
        this.holdingEntities.put(entity.method_5628(), entity);
        this.field_5983 = true;
        if (!(entity instanceof class_1657)) {
            entity.field_5983 = true;
        }
        if (fromPlayerEntityId != 0) {
            this.removePlayerWithId(fromPlayerEntityId);
        }
        if (!this.field_6002.method_8608() && sendPacket && this.field_6002 instanceof class_3218) {
            if (entity instanceof ChainKnotEntity) {
                ++((ChainKnotEntity)entity).holdersCount;
            }
            this.sendAttachChainPacket(entity.method_5628(), fromPlayerEntityId);
        }
    }

    public void sendDetachChainPacket(int entityId) {
        Stream watchingPlayers = PlayerStream.around((class_1937)this.field_6002, (class_2338)this.method_24515(), (double)1024.0);
        class_2540 passedData = new class_2540(Unpooled.buffer());
        passedData.method_10806(new int[]{this.method_5628(), entityId});
        watchingPlayers.forEach(playerEntity -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(playerEntity, NetworkingPackages.S2C_CHAIN_DETACH_PACKET_ID, passedData));
    }

    public void sendAttachChainPacket(int entityId, int fromPlayerEntityId) {
        Stream watchingPlayers = PlayerStream.around((class_1937)this.field_6002, (class_2338)this.method_24515(), (double)1024.0);
        class_2540 passedData = new class_2540(Unpooled.buffer());
        passedData.method_10806(new int[]{this.method_5628(), entityId});
        passedData.writeInt(fromPlayerEntityId);
        watchingPlayers.forEach(playerEntity -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(playerEntity, NetworkingPackages.S2C_CHAIN_ATTACH_PACKET_ID, passedData));
    }

    @Environment(value=EnvType.CLIENT)
    public void addHoldingEntityId(int id, int fromPlayerId) {
        if (fromPlayerId != 0) {
            this.holdingEntities.remove(fromPlayerId);
        }
        this.holdingEntities.put(id, null);
    }

    @Environment(value=EnvType.CLIENT)
    public void removeHoldingEntityId(int id) {
        this.holdingEntities.remove(id);
    }

    @Environment(value=EnvType.CLIENT)
    public void addHoldingEntityIds(int[] ids) {
        for (int id : ids) {
            this.holdingEntities.put(id, null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void removeHoldingEntityIds(int[] ids) {
        for (int id : ids) {
            this.holdingEntities.remove(id);
        }
    }

    public void removePlayerWithId(int entityId) {
        this.holdingEntities.remove(entityId);
    }

    private void deserializeChainTag(class_2487 tag) {
        if (tag != null && this.field_6002 instanceof class_3218) {
            if (tag.method_10545("UUID")) {
                UUID uuid = tag.method_25926("UUID");
                class_1297 entity = ((class_3218)this.field_6002).method_14190(uuid);
                if (entity != null) {
                    this.attachChain(entity, true, 0);
                    this.chainTags.remove((Object)tag);
                    return;
                }
            } else if (tag.method_10545("X")) {
                class_2338 blockPos = new class_2338(tag.method_10550("X"), tag.method_10550("Y"), tag.method_10550("Z"));
                ChainKnotEntity entity = ChainKnotEntity.getOrCreate(this.field_6002, blockPos, true);
                if (entity != null) {
                    this.attachChain((class_1297)ChainKnotEntity.getOrCreate(this.field_6002, blockPos), true, 0);
                    this.chainTags.remove((Object)tag);
                }
                return;
            }
            if (this.field_6012 > 100) {
                this.method_5706((class_1935)class_1802.field_23983);
                this.chainTags.remove((Object)tag);
            }
        }
    }

    public static class_243 middleOf(class_243 a, class_243 b) {
        double x = (a.method_10216() - b.method_10216()) / 2.0 + b.method_10216();
        double y = (a.method_10214() - b.method_10214()) / 2.0 + b.method_10214();
        double z = (a.method_10215() - b.method_10215()) / 2.0 + b.method_10215();
        return new class_243(x, y, z);
    }
}

