/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client;

import com.conquestreforged.client.ModelFilterList;
import com.conquestreforged.client.event.handler.InputHandler;
import com.conquestreforged.client.gui.BlockIdHelper;
import com.conquestreforged.client.init.Binds;
import com.conquestreforged.client.init.Colors;
import com.conquestreforged.client.init.Renderers;
import com.conquestreforged.client.keybind.KeyBind;
import com.conquestreforged.common.CommonProxy;
import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.Tabs;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private final InputHandler events = new InputHandler();

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this.events);
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        OBJLoader.INSTANCE.addDomain("conquest");
        Tabs.preRegisterTabs();
        super.preInit(e);
        Binds.preRegisterBinds();
        Renderers.preRegisterRenderers();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        Renderers.initRegisterRenderers();
        Colors.initRegisterColourHandlers();
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        Binds.postRegisterBinds();
        this.events.getTickables().addAll(KeyBind.getBinds());
        this.events.getTickables().add(BlockIdHelper.getInstance());
    }

    @Override
    public void sendPacket(String channel, FMLProxyPacket packet) {
        this.getChannel("paintings-sync").sendToServer(packet);
    }

    @Override
    public NonNullList<ItemStack> createFilterList(NonNullList<ItemStack> input) {
        return new ModelFilterList((List<ItemStack>)input);
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> e) {
        super.registerItems(e);
        ModBlock.REGISTRAR.registerItemModels();
    }
}

