/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui;

import com.conquestreforged.client.Tickable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockIdHelper
implements Tickable {
    private static final BlockIdHelper instance = new BlockIdHelper();
    private IBlockState lastHit = null;
    private boolean active = false;

    private BlockIdHelper() {
    }

    @Override
    public void tick(boolean inGame) {
        if (inGame && this.active) {
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            if (result == null) {
                return;
            }
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = result.func_178782_a();
                IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
                if (state != this.lastHit) {
                    this.lastHit = state;
                    if (state.func_177230_c() != Blocks.field_150350_a) {
                        int id = Block.func_149682_b((Block)state.func_177230_c());
                        int meta = state.func_177230_c().func_176201_c(state);
                        this.setStatus("%s:%s", id, meta);
                    }
                }
            } else {
                this.lastHit = Blocks.field_150350_a.func_176223_P();
            }
        }
    }

    public boolean toggleActive() {
        this.active = !this.active;
        this.lastHit = Blocks.field_150350_a.func_176223_P();
        return this.active;
    }

    private void setStatus(String format, Object ... args) {
        Minecraft.func_71410_x().field_71456_v.func_110326_a(String.format(format, args), false);
    }

    public static BlockIdHelper getInstance() {
        return instance;
    }
}

