/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui;

import com.conquestreforged.ConquestReforged;
import com.conquestreforged.common.entity.painting.PaintingArt;
import com.conquestreforged.common.entity.painting.PaintingType;
import com.conquestreforged.common.entity.painting.art.Art;
import com.conquestreforged.common.entity.painting.art.ModArt;
import com.conquestreforged.common.entity.painting.art.VanillaArt;
import com.conquestreforged.init.ModItems;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiPainting
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft:textures/gui/spectator_widgets.png");
    private final List<Art> arts;
    private final ResourceLocation texture;
    private final String type;
    private final String typeUnlocal;
    private final List<PaintingType> types;
    private final GuiButton previous = GuiPainting.horizontalArrow(144, 0);
    private final GuiButton next = GuiPainting.horizontalArrow(160, 0);
    private int artIndex;
    private int hoveredIndex = -1;

    public GuiPainting(PaintingType type, PaintingArt art) {
        this.type = type.getName();
        this.typeUnlocal = type.getUnlocalizedName();
        this.texture = type.getResourceLocation();
        this.arts = ModArt.ALL;
        this.artIndex = Art.indexOf(art, ModArt.ALL);
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.types = PaintingType.getOrderedTypes();
    }

    public GuiPainting(EntityPainting.EnumArt art) {
        this.type = "Vanilla";
        this.typeUnlocal = "item.painting.name";
        this.arts = VanillaArt.ALL;
        this.texture = VanillaArt.location;
        this.artIndex = Art.indexOf((Enum)art, VanillaArt.ALL);
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.types = Collections.emptyList();
        this.previous.field_146125_m = false;
        this.next.field_146125_m = false;
    }

    public void func_73866_w_() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.func_189646_b(this.previous);
        this.func_189646_b(this.next);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.hoveredIndex != -1) {
            this.setPainting();
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 205) {
            this.scroll(1);
            return;
        }
        if (keyCode == 203) {
            this.scroll(-1);
            return;
        }
        if (keyCode == 29) {
            return;
        }
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
        this.setPainting();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146292_n.isEmpty()) {
            this.field_146292_n.add(this.next);
            this.field_146292_n.add(this.previous);
        }
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.hoveredIndex = -1;
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        for (int i = 5; i >= 0; --i) {
            if (i > 0) {
                this.drawArt(mouseX, mouseY, centerX, centerY, -i);
            }
            this.drawArt(mouseX, mouseY, centerX, centerY, i);
        }
        this.drawLabel(centerX, centerY);
        this.positionButtons(centerX, centerY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getDWheel();
        if (scroll > 0) {
            this.scroll(-1);
        }
        if (scroll < 0) {
            this.scroll(1);
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button == this.previous) {
            this.changePainting(-1);
        }
        if (button == this.next) {
            this.changePainting(1);
        }
    }

    private void setPainting() {
        int artIndex = this.hoveredIndex == -1 ? this.artIndex : this.hoveredIndex;
        String art = this.arts.get(artIndex).getName();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("TypeID", this.type);
        tag.func_74778_a("ArtID", art);
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150786_a(tag);
        FMLProxyPacket packet = new FMLProxyPacket(buffer, "paintings-sync");
        ConquestReforged.getProxy().sendPacket("paintings-sync", packet);
    }

    private void scroll(int direction) {
        int index;
        if (Keyboard.isKeyDown((int)29)) {
            direction *= 5;
        }
        if ((index = this.artIndex + direction) < 0) {
            index = this.arts.size() - 1 + index;
        } else if (index >= this.arts.size()) {
            index -= this.arts.size();
        }
        this.artIndex = index;
    }

    private void drawArt(int mx, int my, int cx, int cy, int di) {
        int index = this.artIndex + di;
        if (index < 0) {
            index = this.arts.size() - 1 + index;
        }
        if (index >= this.arts.size()) {
            index -= this.arts.size() - 1;
        }
        float scale0 = 2.0f - (float)Math.abs(di) / 4.0f;
        int size = Math.round((float)(this.field_146294_l / 11) * scale0);
        int left = cx + 1 + di * (size + 1) - size / 2;
        int top = cy - size / 2;
        Art art = this.arts.get(index);
        float w = 1.0f;
        float h = 1.0f;
        if (art.width() != art.height()) {
            float scale1 = 1.0f / (float)Math.max(art.width(), art.height());
            w = (float)art.width() * scale1;
            h = (float)art.height() * scale1;
        }
        int tw = Math.round((float)size * w);
        int th = Math.round((float)size * h);
        int tl = left + (size - tw) / 2;
        int tt = top + (size - th) / 2;
        this.handleMouse(mx, my, tl, tt, tw, th, index);
        float alpha = Math.min(1.0f, 0.2f + Math.max(0.0f, 1.0f - (float)Math.abs(di) / 2.0f));
        GlStateManager.func_179131_c((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        Gui.func_152125_a((int)tl, (int)tt, (float)art.u(), (float)art.v(), (int)art.width(), (int)art.height(), (int)tw, (int)th, (float)art.textureWidth(), (float)art.textureHeight());
    }

    private void drawLabel(int centerX, int centerY) {
        String text = String.format("%s [%s]", this.getPaintingName(), this.getArtName());
        int width = this.field_146289_q.func_78256_a(text);
        this.field_146289_q.func_175063_a(text, (float)(centerX - width / 2), (float)(centerY + 64), 0xFFFFFF);
    }

    private void positionButtons(int centerX, int centerY) {
        int buttonTop = centerY + 64 - 4;
        this.next.field_146128_h = centerX + 64;
        this.next.field_146129_i = buttonTop;
        this.previous.field_146128_h = centerX - this.previous.field_146120_f - 64;
        this.previous.field_146129_i = buttonTop;
    }

    private String getPaintingName() {
        return I18n.func_74838_a((String)this.typeUnlocal);
    }

    private String getArtName() {
        int index = this.hoveredIndex != -1 ? this.hoveredIndex : this.artIndex;
        Art art = this.arts.get(index);
        if (this.type.equals("Vanilla")) {
            return art.getName().toLowerCase();
        }
        return art.width() / 16 + "x" + art.height() / 16;
    }

    private void handleMouse(int mx, int my, int l, int t, int w, int h, int index) {
        if (mx >= l && mx <= l + w && my >= t && my <= t + h) {
            this.hoveredIndex = index;
        }
    }

    private void changePainting(int direction) {
        if (this.types.isEmpty()) {
            return;
        }
        PaintingType current = PaintingType.fromId(this.type);
        if (!current.isPresent()) {
            return;
        }
        int index = this.types.indexOf(current) + direction;
        if (index < 0) {
            index = this.types.size() - 1;
        }
        if (index >= this.types.size()) {
            index = 0;
        }
        PaintingType next = this.types.get(index);
        String artName = this.arts.get(this.artIndex).getName();
        PaintingArt art = PaintingArt.fromName(artName);
        GuiPainting gui = new GuiPainting(next, art);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
    }

    private static GuiButtonImage horizontalArrow(int u, int v) {
        int id = 0;
        int x = 0;
        int y = 0;
        int width = 16;
        int height = 16;
        int yDiffText = 0;
        return new GuiButtonImage(id, x, y, width, height, u, v, yDiffText, TEXTURE);
    }

    public static void showPaintGUI(ItemStack stack) {
        GuiPainting gui;
        Item item = stack.func_77973_b();
        String artName = "";
        String artType = "";
        NBTTagCompound data = stack.func_77978_p();
        if (data != null) {
            NBTTagCompound painting = data.func_74775_l("Painting");
            artName = painting.func_74779_i("ArtID");
            artType = painting.func_74779_i("TypeID");
        }
        if (item == Item.func_111206_d((String)"minecraft:painting")) {
            if (artName.isEmpty()) {
                artName = EntityPainting.EnumArt.ALBAN.toString();
            }
            gui = new GuiPainting(EntityPainting.EnumArt.valueOf((String)artName));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        } else if (item == ModItems.vanillaPainting) {
            if (artName.isEmpty()) {
                artName = EntityPainting.EnumArt.ALBAN.toString();
            }
            gui = new GuiPainting(EntityPainting.EnumArt.valueOf((String)artName));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        } else if (item == ModItems.paintingItem) {
            PaintingType type = PaintingType.fromId(artType);
            PaintingArt art = PaintingArt.fromName(artName);
            if (!type.isPresent() || art == null) {
                return;
            }
            GuiPainting gui2 = new GuiPainting(type, art);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui2);
        }
    }
}

