/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.init;

import com.conquestreforged.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Colors {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void initRegisterColourHandlers() {
        BlockColors blockColors = minecraft.func_184125_al();
        ItemColors itemColors = minecraft.getItemColors();
        Colors.registerBlockColourHandlersGrass(blockColors);
        Colors.registerBlockColourHandlersLeaves(blockColors);
        Colors.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlersGrass(BlockColors blockColors) {
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.plants_nocollisionbiome_1.getBlock()});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.vine_jungle.getBlock()});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.vine_ivy.getBlock()});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.vine_moss.getBlock()});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.grass_layer_1.getBlock()});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.grass_full_1.getBlock()});
    }

    private static void registerBlockColourHandlersLeaves(BlockColors blockColors) {
        IBlockColor leafColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
        };
        blockColors.func_186722_a(leafColourHandler, new Block[]{ModBlocks.leaves_fullbiome_1.getBlock()});
        blockColors.func_186722_a(leafColourHandler, new Block[]{ModBlocks.leaves_fullbiome_2.getBlock()});
        blockColors.func_186722_a(leafColourHandler, new Block[]{ModBlocks.leaves_fullbiome_3.getBlock()});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
        };
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.plants_nocollisionbiome_1.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.vine_jungle.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.vine_ivy.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.vine_moss.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.grass_layer_1.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.leaves_fullbiome_1.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.grass_full_1.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.leaves_fullbiome_2.getBlock()});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.leaves_fullbiome_3.getBlock()});
    }
}

