/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.keybind;

import com.conquestreforged.client.Tickable;
import com.conquestreforged.client.keybind.Action;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class KeyBind
implements Tickable {
    private static final String CATEGORY = "Conquest Reforged";
    private static final List<KeyBind> binds = new LinkedList<KeyBind>();
    private final KeyBinding key;
    private final Action action;
    private final boolean wrapped;
    private boolean keyDown = false;

    private KeyBind(KeyBinding wrapped, Action action) {
        this.key = wrapped;
        this.action = action;
        this.wrapped = true;
        binds.add(this);
    }

    private KeyBind(String id, int code, Action action) {
        this.key = new KeyBinding(id, code, CATEGORY);
        this.action = action;
        this.wrapped = false;
        binds.add(this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key);
    }

    @Override
    public void tick(boolean inGame) {
        boolean pressed;
        if (!inGame) {
            return;
        }
        if (this.wrapped) {
            boolean down = this.key.func_151463_i() < 0 ? Mouse.isButtonDown((int)(this.key.func_151463_i() + 100)) : Keyboard.isKeyDown((int)this.key.func_151463_i());
            pressed = !this.keyDown && down;
            this.keyDown = down;
        } else {
            pressed = this.key.func_151468_f();
        }
        if (pressed) {
            try {
                this.action.perform();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static KeyBind of(String id, int code, Action action) {
        return new KeyBind(String.format("key.conquest.button.%s", id), code, action);
    }

    public static KeyBind wrap(KeyBinding key, Action action) {
        return new KeyBind(key, action);
    }

    public static List<KeyBind> getBinds() {
        return binds;
    }
}

