/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common;

import com.conquestreforged.Proxy;
import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.command.PaintCommand;
import com.conquestreforged.common.event.handler.BlockDropHandler;
import com.conquestreforged.common.event.handler.LootTableHandler;
import com.conquestreforged.common.event.handler.MobDropHandler;
import com.conquestreforged.common.event.handler.PaintingSyncHandler;
import com.conquestreforged.common.event.handler.SeatUseHandler;
import com.conquestreforged.common.world.ModWorldType;
import com.conquestreforged.common.world.OreGenerator;
import com.conquestreforged.common.world.VanillaOreRemover;
import com.conquestreforged.init.Data;
import com.conquestreforged.init.Entities;
import com.conquestreforged.init.ModBiomes;
import com.conquestreforged.init.ModBlocks;
import com.conquestreforged.init.ModItems;
import com.conquestreforged.init.ModOreDictionary;
import com.conquestreforged.init.ModSmelting;
import com.conquestreforged.init.block.BlockFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class CommonProxy
implements Proxy {
    private final Map<String, FMLEventChannel> channels = new HashMap<String, FMLEventChannel>();

    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SeatUseHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockDropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobDropHandler());
        FMLEventChannel paintingSync = NetworkRegistry.INSTANCE.newEventDrivenChannel("paintings-sync");
        paintingSync.register((Object)new PaintingSyncHandler());
        this.channels.put("paintings-sync", paintingSync);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> e) {
        ModBlock.REGISTRAR.registerBlocks((IForgeRegistry<Block>)e.getRegistry());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        ModBlock.REGISTRAR.registerItems((IForgeRegistry<Item>)e.getRegistry());
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        BlockFactory.getInstance();
        Data.preRegisterProcessors();
        ModBlocks.preRegisterBlocks();
        ModItems.preRegisterItems();
        ModItems.register();
        Entities.preRegisterEntities();
        ModBiomes.preRegisterBiomes();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        ModSmelting.addSmeltingRecipes();
        MinecraftForge.ORE_GEN_BUS.register(VanillaOreRemover.class);
        ModOreDictionary.registerGeneralOres();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        Data.postRegisterData();
        ModBlock.REGISTRAR.dispose();
        new ModWorldType("conquest");
    }

    @Override
    public void serverStart(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new PaintCommand());
    }

    protected FMLEventChannel getChannel(String channel) {
        return this.channels.get(channel);
    }
}

