/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.block.BedBlock;
import com.conquestreforged.common.block.DamageLayerBlock;
import com.conquestreforged.common.block.DoorBlock;
import com.conquestreforged.common.block.LilypadBlock;
import com.conquestreforged.common.blockmeta.BlockLayerMeta;
import com.conquestreforged.common.blockmeta.IMetaBlock;
import com.conquestreforged.common.item.BedItem;
import com.conquestreforged.common.item.DoorItem;
import com.conquestreforged.common.item.ItemBlockMeta;
import com.conquestreforged.common.item.ItemBlockSimple;
import com.conquestreforged.common.item.ItemLayerMeta;
import com.conquestreforged.common.item.LilyPadItem;
import com.conquestreforged.common.item.SnowItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlockRegistrar
implements Iterable<ModBlock> {
    private Map<ModBlock, ModBlockItem> registry = new LinkedHashMap<ModBlock, ModBlockItem>();

    @Override
    public Iterator<ModBlock> iterator() {
        return this.registry.keySet().iterator();
    }

    private void check() {
        if (this.registry == Collections.EMPTY_MAP) {
            throw new IllegalStateException("Attempting to access ModBlock registry after it has been disposed!");
        }
    }

    public void dispose() {
        this.check();
        this.registry.clear();
        this.registry = Collections.emptyMap();
    }

    public void register(ModBlock block) {
        this.check();
        ItemBlock itemBlock = ModBlockRegistrar.getItem(block.getBlock());
        ModBlockItem item = new ModBlockItem(itemBlock);
        this.registry.put(block, item);
    }

    public ModBlockItem getItem(ModBlock block) {
        this.check();
        return this.registry.get(block);
    }

    public void iterate(Consumer<ItemBlock> itemConsumer) {
        this.check();
        for (ModBlockItem item : this.registry.values()) {
            itemConsumer.accept(item.getItem());
        }
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        this.check();
        for (ModBlockItem item : this.registry.values()) {
            item.registerBlock((IForgeRegistry<Block>)registry);
        }
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        this.check();
        for (ModBlockItem item : this.registry.values()) {
            item.registerItem((IForgeRegistry<Item>)registry);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        this.check();
        for (ModBlockItem item : this.registry.values()) {
            item.registerModels();
        }
    }

    private static ItemBlock getItem(Block block) {
        Class<?> type = block.getClass();
        if (type == BedBlock.class) {
            return new BedItem(block);
        }
        if (type == DoorBlock.class) {
            return new DoorItem(block);
        }
        if (type == BlockLayerMeta.class) {
            return new ItemLayerMeta(block);
        }
        if (type == LilypadBlock.class) {
            return new LilyPadItem(block);
        }
        if (type == DamageLayerBlock.class) {
            return new SnowItem(block);
        }
        if (IMetaBlock.class.isInstance(block)) {
            return new ItemBlockMeta(block);
        }
        return new ItemBlockSimple(block);
    }

    static class ModBlockItem {
        private final ItemBlock item;
        private List<String> variants = Collections.emptyList();

        ModBlockItem(ItemBlock itemBlock) {
            this.item = itemBlock;
        }

        public List<String> getVariants() {
            return this.variants;
        }

        public ItemBlock getItem() {
            return this.item;
        }

        public void variant(int meta, String name) {
            if (this.variants.isEmpty()) {
                this.variants = new ArrayList<String>(16);
            }
            this.variants.add(meta, name);
        }

        private void registerBlock(IForgeRegistry<Block> registry) {
            registry.register((IForgeRegistryEntry)this.item.func_179223_d());
        }

        private void registerItem(IForgeRegistry<Item> registry) {
            this.item.setRegistryName(this.item.func_179223_d().getRegistryName());
            registry.register((IForgeRegistryEntry)this.item);
        }

        @SideOnly(value=Side.CLIENT)
        private void registerModels() {
            if (this.variants.isEmpty()) {
                this.registerModel(this.item.getRegistryName(), 0);
            } else {
                for (int i = 0; i < this.variants.size(); ++i) {
                    String variant = this.variants.get(i);
                    this.registerModel(variant, i);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void registerModel(Object variant, int id) {
            if (variant != null) {
                ModelResourceLocation model = new ModelResourceLocation(variant.toString(), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)this.item, (int)id, (ModelResourceLocation)model);
            }
        }
    }
}

