/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlowerpotBlock
extends BlockContainer
implements ModBlock {
    private boolean canSustainPlant;
    public static final PropertyEnum<EnumFlowerType> CONTENTS = PropertyEnum.func_177709_a((String)"contents", EnumFlowerType.class);
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public FlowerpotBlock(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState((Block)this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public FlowerpotBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENTS, (Comparable)((Object)EnumFlowerType.EMPTY)));
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemBlock) {
            TileEntityFlowerPot tileentityflowerpot = this.getTileEntity(worldIn, pos);
            if (tileentityflowerpot == null) {
                return false;
            }
            if (tileentityflowerpot.func_145965_a() != null) {
                return false;
            }
            Block block = Block.func_149634_a((Item)heldItem.func_77973_b());
            if (!this.canContain(block, heldItem.func_77960_j())) {
                return false;
            }
            tileentityflowerpot.func_190614_a(heldItem);
            tileentityflowerpot.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 3);
            playerIn.func_71029_a(StatList.field_188088_V);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
            }
            return true;
        }
        return false;
    }

    private boolean canContain(Block blockIn, int meta) {
        return blockIn == Blocks.field_150327_N || blockIn == Blocks.field_150328_O || blockIn == Blocks.field_150434_aF || blockIn == Blocks.field_150338_P || blockIn == Blocks.field_150337_Q || blockIn == Blocks.field_150345_g || blockIn == Blocks.field_150330_I || blockIn == Blocks.field_150329_H && meta == BlockTallGrass.EnumType.FERN.func_177044_a();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityFlowerPot tileentityflowerpot;
        super.func_176208_a(worldIn, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityflowerpot = this.getTileEntity(worldIn, pos)) != null) {
            tileentityflowerpot.func_190614_a(ItemStack.field_190927_a);
        }
    }

    private TileEntityFlowerPot getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)tileentity : null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        BlockFlower block = null;
        int i = 0;
        switch (meta) {
            case 1: {
                block = Blocks.field_150328_O;
                i = BlockFlower.EnumFlowerType.POPPY.func_176968_b();
                break;
            }
            case 2: {
                block = Blocks.field_150327_N;
                break;
            }
            case 3: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.OAK.func_176839_a();
                break;
            }
            case 4: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.SPRUCE.func_176839_a();
                break;
            }
            case 5: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.BIRCH.func_176839_a();
                break;
            }
            case 6: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.JUNGLE.func_176839_a();
                break;
            }
            case 7: {
                block = Blocks.field_150337_Q;
                break;
            }
            case 8: {
                block = Blocks.field_150338_P;
                break;
            }
            case 9: {
                block = Blocks.field_150434_aF;
                break;
            }
            case 10: {
                block = Blocks.field_150330_I;
                break;
            }
            case 11: {
                block = Blocks.field_150329_H;
                i = BlockTallGrass.EnumType.FERN.func_177044_a();
                break;
            }
            case 12: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.ACACIA.func_176839_a();
                break;
            }
            case 13: {
                block = Blocks.field_150345_g;
                i = BlockPlanks.EnumType.DARK_OAK.func_176839_a();
            }
        }
        return new TileEntityFlowerPot(Item.func_150898_a((Block)block), i);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENTS});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityFlowerPot tileentityflowerpot;
        Item item;
        EnumFlowerType Flowerpot$enumflowertype = EnumFlowerType.EMPTY;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityFlowerPot && (item = (tileentityflowerpot = (TileEntityFlowerPot)tileentity).func_145965_a()) instanceof ItemBlock) {
            int i = tileentityflowerpot.func_145966_b();
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150345_g) {
                switch (BlockPlanks.EnumType.func_176837_a((int)i)) {
                    case OAK: {
                        Flowerpot$enumflowertype = EnumFlowerType.OAK_SAPLING;
                        break;
                    }
                    case SPRUCE: {
                        Flowerpot$enumflowertype = EnumFlowerType.SPRUCE_SAPLING;
                        break;
                    }
                    case BIRCH: {
                        Flowerpot$enumflowertype = EnumFlowerType.BIRCH_SAPLING;
                        break;
                    }
                    case JUNGLE: {
                        Flowerpot$enumflowertype = EnumFlowerType.JUNGLE_SAPLING;
                        break;
                    }
                    case ACACIA: {
                        Flowerpot$enumflowertype = EnumFlowerType.ACACIA_SAPLING;
                        break;
                    }
                    case DARK_OAK: {
                        Flowerpot$enumflowertype = EnumFlowerType.DARK_OAK_SAPLING;
                        break;
                    }
                    default: {
                        Flowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.field_150329_H) {
                switch (i) {
                    case 0: {
                        Flowerpot$enumflowertype = EnumFlowerType.DEAD_BUSH;
                        break;
                    }
                    case 2: {
                        Flowerpot$enumflowertype = EnumFlowerType.FERN;
                        break;
                    }
                    default: {
                        Flowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.field_150327_N) {
                Flowerpot$enumflowertype = EnumFlowerType.DANDELION;
            } else if (block == Blocks.field_150328_O) {
                switch (BlockFlower.EnumFlowerType.func_176967_a((BlockFlower.EnumFlowerColor)BlockFlower.EnumFlowerColor.RED, (int)i)) {
                    case POPPY: {
                        Flowerpot$enumflowertype = EnumFlowerType.POPPY;
                        break;
                    }
                    case BLUE_ORCHID: {
                        Flowerpot$enumflowertype = EnumFlowerType.BLUE_ORCHID;
                        break;
                    }
                    case ALLIUM: {
                        Flowerpot$enumflowertype = EnumFlowerType.ALLIUM;
                        break;
                    }
                    case HOUSTONIA: {
                        Flowerpot$enumflowertype = EnumFlowerType.HOUSTONIA;
                        break;
                    }
                    case RED_TULIP: {
                        Flowerpot$enumflowertype = EnumFlowerType.RED_TULIP;
                        break;
                    }
                    case ORANGE_TULIP: {
                        Flowerpot$enumflowertype = EnumFlowerType.ORANGE_TULIP;
                        break;
                    }
                    case WHITE_TULIP: {
                        Flowerpot$enumflowertype = EnumFlowerType.WHITE_TULIP;
                        break;
                    }
                    case PINK_TULIP: {
                        Flowerpot$enumflowertype = EnumFlowerType.PINK_TULIP;
                        break;
                    }
                    case OXEYE_DAISY: {
                        Flowerpot$enumflowertype = EnumFlowerType.OXEYE_DAISY;
                        break;
                    }
                    default: {
                        Flowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.field_150337_Q) {
                Flowerpot$enumflowertype = EnumFlowerType.MUSHROOM_RED;
            } else if (block == Blocks.field_150338_P) {
                Flowerpot$enumflowertype = EnumFlowerType.MUSHROOM_BROWN;
            } else if (block == Blocks.field_150330_I) {
                Flowerpot$enumflowertype = EnumFlowerType.DEAD_BUSH;
            } else if (block == Blocks.field_150434_aF) {
                Flowerpot$enumflowertype = EnumFlowerType.CACTUS;
            }
        }
        return state.func_177226_a(CONTENTS, (Comparable)((Object)Flowerpot$enumflowertype));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFlowerPot te;
        List ret = super.getDrops(world, pos, state, fortune);
        TileEntityFlowerPot tileEntityFlowerPot = te = world.func_175625_s(pos) instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)world.func_175625_s(pos) : null;
        if (te != null && te.func_145965_a() != null) {
            ret.add(new ItemStack(te.func_145965_a(), 1, te.func_145966_b()));
        }
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public static enum EnumFlowerType implements IStringSerializable
    {
        EMPTY("empty"),
        POPPY("rose"),
        BLUE_ORCHID("blue_orchid"),
        ALLIUM("allium"),
        HOUSTONIA("houstonia"),
        RED_TULIP("red_tulip"),
        ORANGE_TULIP("orange_tulip"),
        WHITE_TULIP("white_tulip"),
        PINK_TULIP("pink_tulip"),
        OXEYE_DAISY("oxeye_daisy"),
        DANDELION("dandelion"),
        OAK_SAPLING("oak_sapling"),
        SPRUCE_SAPLING("spruce_sapling"),
        BIRCH_SAPLING("birch_sapling"),
        JUNGLE_SAPLING("jungle_sapling"),
        ACACIA_SAPLING("acacia_sapling"),
        DARK_OAK_SAPLING("dark_oak_sapling"),
        MUSHROOM_RED("mushroom_red"),
        MUSHROOM_BROWN("mushroom_brown"),
        DEAD_BUSH("dead_bush"),
        FERN("fern"),
        CACTUS("cactus");

        private final String name;

        private EnumFlowerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

