/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HookBlock
extends Block
implements ModBlock {
    private boolean canSustainPlant;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool ATTACHED = PropertyBool.func_177716_a((String)"attached");
    protected static final AxisAlignedBB HOOK_NORTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB HOOK_SOUTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.625, 0.375);
    protected static final AxisAlignedBB HOOK_WEST_AABB = new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB HOOK_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.625, 0.6875);

    public HookBlock(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState(this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
        this.func_149675_a(true);
    }

    public HookBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)ATTACHED, (Comparable)Boolean.FALSE));
        this.func_149675_a(true);
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return HOOK_EAST_AABB;
            }
            case WEST: {
                return HOOK_WEST_AABB;
            }
            case SOUTH: {
                return HOOK_SOUTH_AABB;
            }
            case NORTH: 
        }
        return HOOK_NORTH_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side.func_176740_k().func_176722_c() && worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).isSideSolid((IBlockAccess)worldIn, pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)ATTACHED, (Comparable)Boolean.FALSE);
        if (facing.func_176740_k().func_176722_c()) {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return iblockstate;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.func_176260_a(worldIn, pos, state, false, false, -1, null);
    }

    public void func_176260_a(World worldIn, BlockPos pos, IBlockState hookState, boolean p_176260_4_, boolean p_176260_5_, int p_176260_6_, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)hookState.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)hookState.func_177229_b((IProperty)ATTACHED);
        boolean flag1 = (Boolean)hookState.func_177229_b((IProperty)POWERED);
        boolean flag2 = !p_176260_4_;
        boolean flag3 = false;
        int i = 0;
        IBlockState[] aiblockstate = new IBlockState[42];
        for (int j = 1; j < 42; ++j) {
            BlockPos blockpos = pos.func_177967_a(enumfacing, j);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() == Blocks.field_150473_bD) {
                if (iblockstate.func_177229_b((IProperty)FACING) != enumfacing.func_176734_d()) break;
                i = j;
                break;
            }
            if (iblockstate.func_177230_c() != Blocks.field_150473_bD && j != p_176260_6_) {
                aiblockstate[j] = null;
                flag2 = false;
                continue;
            }
            if (j == p_176260_6_) {
                iblockstate = iblockstate == null ? state : iblockstate;
            }
            boolean flag4 = (Boolean)iblockstate.func_177229_b((IProperty)BlockTripWire.field_176295_N) == false;
            boolean flag5 = (Boolean)iblockstate.func_177229_b((IProperty)BlockTripWire.field_176293_a);
            flag3 |= flag4 && flag5;
            aiblockstate[j] = iblockstate;
            if (j != p_176260_6_) continue;
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            flag2 &= flag4;
        }
        flag2 = flag2 && i > 1;
        flag3 = flag3 && flag2;
        IBlockState iblockstate1 = this.func_176223_P().func_177226_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf(flag2)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag3));
        if (i > 0) {
            BlockPos blockpos1 = pos.func_177967_a(enumfacing, i);
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_180501_a(blockpos1, iblockstate1.func_177226_a((IProperty)FACING, (Comparable)enumfacing1), 3);
            this.func_176262_b(worldIn, blockpos1, enumfacing1);
            this.func_180694_a(worldIn, blockpos1, flag2, flag3, flag, flag1);
        }
        this.func_180694_a(worldIn, pos, flag2, flag3, flag, flag1);
        if (!p_176260_4_) {
            worldIn.func_180501_a(pos, iblockstate1.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 3);
            if (p_176260_5_) {
                this.func_176262_b(worldIn, pos, enumfacing);
            }
        }
        if (flag != flag2) {
            for (int k = 1; k < i; ++k) {
                BlockPos blockpos2 = pos.func_177967_a(enumfacing, k);
                IBlockState iblockstate2 = aiblockstate[k];
                if (iblockstate2 == null || worldIn.func_180495_p(blockpos2).func_177230_c() == Blocks.field_150350_a) continue;
                worldIn.func_180501_a(blockpos2, iblockstate2.func_177226_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf(flag2)), 3);
            }
        }
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.func_176260_a(worldIn, pos, state, false, true, -1, null);
    }

    private void func_180694_a(World worldIn, BlockPos pos, boolean p_180694_3_, boolean p_180694_4_, boolean p_180694_5_, boolean p_180694_6_) {
        if (p_180694_4_ && !p_180694_6_) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 0.4f, 0.6f);
        } else if (!p_180694_4_ && p_180694_6_) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187906_gf, SoundCategory.BLOCKS, 0.4f, 0.5f);
        } else if (p_180694_3_ && !p_180694_5_) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187905_ge, SoundCategory.BLOCKS, 0.4f, 0.7f);
        } else if (!p_180694_3_ && p_180694_5_) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187908_gh, SoundCategory.BLOCKS, 0.4f, 1.2f / (worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f));
        }
    }

    private void func_176262_b(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this, false);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag = (Boolean)state.func_177229_b((IProperty)ATTACHED);
        boolean flag1 = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (flag || flag1) {
            this.func_176260_a(worldIn, pos, state, true, false, -1, null);
        }
        if (flag1) {
            worldIn.func_175685_c(pos, (Block)this, false);
            worldIn.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) == false ? 0 : (blockState.func_177229_b((IProperty)FACING) == side ? 15 : 0);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)ATTACHED, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)ATTACHED)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, ATTACHED});
    }
}

