/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class RailBlock
extends BlockRailBase
implements ModBlock {
    private boolean canSustainPlant;
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177709_a((String)"shape", BlockRailBase.EnumRailDirection.class);

    public RailBlock(BlockInfo info) {
        super(false);
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState((Block)this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public RailBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(false);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH));
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)).func_177015_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = (BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (blockrailbase$enumraildirection) {
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (blockrailbase$enumraildirection) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return state.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos other) {
        if (!worldIn.field_72995_K) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
            boolean flag = false;
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                flag = true;
            }
            if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_EAST && !worldIn.func_180495_p(pos.func_177974_f()).isSideSolid((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_WEST && !worldIn.func_180495_p(pos.func_177976_e()).isSideSolid((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_NORTH && !worldIn.func_180495_p(pos.func_177978_c()).isSideSolid((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH && !worldIn.func_180495_p(pos.func_177968_d()).isSideSolid((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.UP)) {
                flag = true;
            }
        }
    }
}

