/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlabDirectionalBlock
extends Block
implements ModBlock {
    private boolean canSustainPlant;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<BlockTrapDoor.DoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockTrapDoor.DoorHalf.class);
    protected static final AxisAlignedBB field_185734_d = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB field_185735_e = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185736_f = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB field_185737_g = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB field_185732_B = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB field_185733_C = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    public SlabDirectionalBlock(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState(this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public SlabDirectionalBlock(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)BlockTrapDoor.DoorHalf.BOTTOM));
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 60;
        }
        if (material == Material.field_151585_k) {
            return 100;
        }
        if (material == Material.field_151582_l) {
            return 100;
        }
        if (material == Material.field_151580_n) {
            return 60;
        }
        if (material == Material.field_151575_d) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 30;
        }
        if (material == Material.field_151585_k) {
            return 60;
        }
        if (material == Material.field_151582_l) {
            return 15;
        }
        if (material == Material.field_151580_n) {
            return 30;
        }
        if (material == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB axisalignedbb = state.func_177229_b(HALF) == BlockTrapDoor.DoorHalf.TOP ? field_185733_C : field_185732_B;
        return axisalignedbb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = this.func_176223_P();
        if (facing.func_176740_k().func_176722_c()) {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing);
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)(hitY > 0.5f ? BlockTrapDoor.DoorHalf.TOP : BlockTrapDoor.DoorHalf.BOTTOM));
        } else {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)(facing == EnumFacing.UP ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP));
        }
        return iblockstate;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    protected static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)SlabDirectionalBlock.getFacing(meta)).func_177226_a(HALF, (Comparable)((meta & 8) == 0 ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= SlabDirectionalBlock.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (state.func_177229_b(HALF) == BlockTrapDoor.DoorHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF});
    }

    public static enum DoorHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private DoorHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

