/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.blockmeta;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.blockmeta.IMetaBlock;
import com.conquestreforged.init.block.BlockInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArrowSlitMeta
extends BlockHorizontal
implements IMetaBlock,
ModBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB north_fr = new AxisAlignedBB(0.0, 0.0, 0.5625, 0.0625, 1.0, 0.8125);
    protected static final AxisAlignedBB north_fl = new AxisAlignedBB(0.0, 0.0, 0.1875, 0.0625, 1.0, 0.4375);
    protected static final AxisAlignedBB north_sr = new AxisAlignedBB(0.0, 0.0, 0.8125, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB north_sl = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.1875);
    protected static final AxisAlignedBB south_fr = new AxisAlignedBB(1.0, 0.0, 0.5625, 0.9375, 1.0, 0.8125);
    protected static final AxisAlignedBB south_fl = new AxisAlignedBB(1.0, 0.0, 0.1875, 0.9375, 1.0, 0.4375);
    protected static final AxisAlignedBB south_sr = new AxisAlignedBB(1.0, 0.0, 0.8125, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB south_sl = new AxisAlignedBB(1.0, 0.0, 0.0, 0.5, 1.0, 0.1875);
    protected static final AxisAlignedBB west_fr = new AxisAlignedBB(0.5625, 0.0, 0.9375, 0.8125, 1.0, 1.0);
    protected static final AxisAlignedBB west_fl = new AxisAlignedBB(0.1875, 0.0, 0.9375, 0.4375, 1.0, 1.0);
    protected static final AxisAlignedBB west_sr = new AxisAlignedBB(0.8125, 0.0, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB west_sl = new AxisAlignedBB(0.0, 0.0, 0.5, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB east_fr = new AxisAlignedBB(0.5625, 0.0, 0.0625, 0.8125, 1.0, 0.0);
    protected static final AxisAlignedBB east_fl = new AxisAlignedBB(0.1875, 0.0, 0.0625, 0.4375, 1.0, 0.0);
    protected static final AxisAlignedBB east_sr = new AxisAlignedBB(0.8125, 0.0, 0.5, 1.0, 1.0, 0.0);
    protected static final AxisAlignedBB east_sl = new AxisAlignedBB(0.0, 0.0, 0.5, 0.1875, 1.0, 0.0);
    private boolean canSustainPlant;

    public BlockArrowSlitMeta(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState((Block)this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public BlockArrowSlitMeta(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)EnumType.ALPHA)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 60;
        }
        if (material == Material.field_151585_k) {
            return 100;
        }
        if (material == Material.field_151582_l) {
            return 100;
        }
        if (material == Material.field_151580_n) {
            return 60;
        }
        if (material == Material.field_151575_d) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 30;
        }
        if (material == Material.field_151585_k) {
            return 60;
        }
        if (material == Material.field_151582_l) {
            return 15;
        }
        if (material == Material.field_151580_n) {
            return 30;
        }
        if (material == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean flag) {
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(state)) {
            BlockArrowSlitMeta.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    private AxisAlignedBB[] getCollisionBoxList(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return new AxisAlignedBB[]{north_fr, north_fl, north_sr, north_sl};
            }
            case SOUTH: {
                return new AxisAlignedBB[]{south_fr, south_fl, south_sr, south_sl};
            }
            case WEST: {
                return new AxisAlignedBB[]{west_fr, west_fl, west_sr, west_sl};
            }
            case EAST: 
        }
        return new AxisAlignedBB[]{east_fr, east_fl, east_sr, east_sl};
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        EnumType[] allType;
        for (EnumType type : allType = EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumType enumtype = EnumType.byMetadata(meta);
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a(VARIANT, (Comparable)((Object)enumtype));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        int facingbits = (meta & 0xC) >> 2;
        EnumFacing facing = EnumFacing.func_176731_b((int)facingbits);
        EnumType variant = EnumType.byMetadata(meta & 3);
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)).func_177226_a((IProperty)field_185512_D, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        EnumType variant = (EnumType)((Object)state.func_177229_b(VARIANT));
        int facingbits = facing.func_176736_b() << 2;
        int variantbits = variant.getMetadata();
        return facingbits | variantbits;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        ALPHA(0, "alpha"),
        BRAVO(1, "bravo"),
        CHARLIE(2, "charlie"),
        DELTA(3, "delta");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockhorizontal$enumtype;
                EnumType.META_LOOKUP[blockhorizontal$enumtype.getMetadata()] = blockhorizontal$enumtype = enumTypeArray[i];
            }
        }
    }
}

