/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.blockmeta;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirectionalSwitches
extends BlockHorizontal
implements ModBlock {
    public static final PropertyInteger ACTIVATED = PropertyInteger.func_177719_a((String)"activated", (int)1, (int)4);
    private boolean canSustainPlant;

    public BlockDirectionalSwitches(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState((Block)this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public BlockDirectionalSwitches(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVATED, (Comparable)Integer.valueOf(1)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 60;
        }
        if (material == Material.field_151585_k) {
            return 100;
        }
        if (material == Material.field_151582_l) {
            return 100;
        }
        if (material == Material.field_151580_n) {
            return 60;
        }
        if (material == Material.field_151575_d) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 30;
        }
        if (material == Material.field_151585_k) {
            return 60;
        }
        if (material == Material.field_151582_l) {
            return 15;
        }
        if (material == Material.field_151580_n) {
            return 30;
        }
        if (material == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVATED, (Comparable)Integer.valueOf(1));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!playerIn.field_71075_bZ.field_75099_e) {
            return false;
        }
        worldIn.func_180501_a(pos, state.func_177231_a((IProperty)ACTIVATED), 3);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ACTIVATED, (Comparable)Integer.valueOf(1 + (meta >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)ACTIVATED) - 1 << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVATED, field_185512_D});
    }
}

