/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.blockmeta;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.blockmeta.IMetaBlock;
import com.conquestreforged.init.block.BlockInfo;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLayerMeta
extends Block
implements ModBlock,
IMetaBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyEnum<EnumHeight> HEIGHT = PropertyEnum.func_177709_a((String)"height", EnumHeight.class);
    protected static final AxisAlignedBB[] SNOW_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockLayerMeta(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState(this));
        this.field_149783_u = info.useNeighborBrightness();
    }

    public BlockLayerMeta(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HEIGHT, (Comparable)((Object)EnumHeight.HEIGHT2)).func_177226_a(VARIANT, (Comparable)((Object)EnumType.ALPHA)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        this.field_149783_u = true;
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 60;
        }
        if (material == Material.field_151585_k) {
            return 100;
        }
        if (material == Material.field_151582_l) {
            return 100;
        }
        if (material == Material.field_151580_n) {
            return 60;
        }
        if (material == Material.field_151575_d) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 30;
        }
        if (material == Material.field_151585_k) {
            return 60;
        }
        if (material == Material.field_151582_l) {
            return 15;
        }
        if (material == Material.field_151580_n) {
            return 30;
        }
        if (material == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
        int layers = ((EnumHeight)((Object)state.func_177229_b(HEIGHT))).getMetadata();
        int meta = ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        drops.add((Object)new ItemStack((Block)this, layers, meta));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        int i = ((EnumHeight)((Object)blockState.func_177229_b(HEIGHT))).getMetadata();
        float f = 0.125f;
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SNOW_AABB[((EnumHeight)((Object)state.func_177229_b(HEIGHT))).getMetadata()];
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return ((EnumHeight)((Object)worldIn.func_180495_p(pos).func_177229_b(HEIGHT))).getMetadata() < 5;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return ((EnumHeight)((Object)worldIn.func_180495_p(pos).func_177229_b(HEIGHT))).getMetadata() == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        return iblockstate.func_177230_c() == this && ((EnumHeight)((Object)iblockstate.func_177229_b(HEIGHT))).getMetadata() >= ((EnumHeight)((Object)blockState.func_177229_b(HEIGHT))).getMetadata() || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public int func_180651_a(IBlockState state) {
        EnumType enumvariant = (EnumType)((Object)state.func_177229_b(VARIANT));
        return enumvariant.getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocklayerr$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocklayerr$enumtype.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        int variantbits = meta & 1;
        int heightbits = (meta & 0xE) >> 1;
        EnumType variant = EnumType.byMetadata(variantbits);
        EnumHeight height = EnumHeight.byMetadata(heightbits);
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)).func_177226_a(HEIGHT, (Comparable)((Object)height));
    }

    public int func_176201_c(IBlockState state) {
        EnumType variant = (EnumType)((Object)state.func_177229_b(VARIANT));
        EnumHeight height = (EnumHeight)((Object)state.func_177229_b(HEIGHT));
        int variantbits = variant.getMetadata();
        int heightbits = height.getMetadata() << 1;
        return heightbits | variantbits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HEIGHT, VARIANT});
    }

    public static enum EnumType implements IStringSerializable
    {
        ALPHA(0, "alpha"),
        BRAVO(1, "bravo");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta > META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocklayer$enumtype;
                EnumType.META_LOOKUP[blocklayer$enumtype.getMetadata()] = blocklayer$enumtype = enumTypeArray[i];
            }
        }
    }

    public static enum EnumHeight implements IStringSerializable
    {
        HEIGHT2(0, "height2"),
        HEIGHT4(1, "height4"),
        HEIGHT6(2, "height6"),
        HEIGHT8(3, "height8"),
        HEIGHT10(4, "height10"),
        HEIGHT12(5, "height12"),
        HEIGHT14(6, "height14"),
        FULL(7, "full");

        private static final EnumHeight[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumHeight(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumHeight byMetadata(int meta) {
            if (meta < 0 || meta > META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumHeight[EnumHeight.values().length];
            EnumHeight[] enumHeightArray = EnumHeight.values();
            int n = enumHeightArray.length;
            for (int i = 0; i < n; ++i) {
                EnumHeight blocklayer$enumheight;
                EnumHeight.META_LOOKUP[blocklayer$enumheight.getMetadata()] = blocklayer$enumheight = enumHeightArray[i];
            }
        }
    }
}

