/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.blockmeta;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.blockmeta.IMetaBlock;
import com.conquestreforged.common.world.generation.WorldGenAcaciaTree;
import com.conquestreforged.common.world.generation.WorldGenAppleTree;
import com.conquestreforged.common.world.generation.WorldGenAspenTree;
import com.conquestreforged.common.world.generation.WorldGenMistletoeTree;
import com.conquestreforged.common.world.generation.WorldGenOakTree;
import com.conquestreforged.common.world.generation.WorldGenPineTree;
import com.conquestreforged.common.world.generation.WorldGenSpruceTree;
import com.conquestreforged.common.world.generation.WorldTreeCherryFruit;
import com.conquestreforged.init.block.BlockInfo;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSapling2Meta
extends BlockBush
implements ModBlock,
IMetaBlock,
IGrowable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private boolean canSustainPlant;

    public BlockSapling2Meta(BlockInfo info) {
        super(info.getMaterial());
        this.func_149672_a(info.getSound());
        this.func_180632_j(info.getDefaultState((Block)this));
        this.canSustainPlant = info.canSustainPlant();
        this.field_149783_u = info.useNeighborBrightness();
    }

    public BlockSapling2Meta(String nameIn, String unlocalizedNameIn, Material materialIn, float hardness, float resistance, SoundType sound, float lightLevel, String tool, int toolLevel, boolean canSustainPlant, CreativeTabs tab) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.ALPHA)));
        this.setRegistryName(nameIn);
        this.func_149663_c(unlocalizedNameIn);
        this.func_149647_a(tab);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149715_a(lightLevel);
        if (tool != null) {
            this.setHarvestLevel(tool, toolLevel);
        }
        this.canSustainPlant = canSustainPlant;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 60;
        }
        if (material == Material.field_151585_k) {
            return 100;
        }
        if (material == Material.field_151582_l) {
            return 100;
        }
        if (material == Material.field_151580_n) {
            return 60;
        }
        if (material == Material.field_151575_d) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        Material material = world.func_180495_p(pos).func_185904_a();
        if (material == Material.field_151584_j) {
            return 30;
        }
        if (material == Material.field_151585_k) {
            return 60;
        }
        if (material == Material.field_151582_l) {
            return 15;
        }
        if (material == Material.field_151580_n) {
            return 30;
        }
        if (material == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH);
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        if (this.canSustainPlant) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.generateTree(worldIn, pos, state, rand);
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case ALPHA: {
                worldgenerator = new WorldGenOakTree(false);
                break;
            }
            case BRAVO: {
                worldgenerator = new WorldGenSpruceTree(false);
                break;
            }
            case CHARLIE: {
                worldgenerator = new WorldGenPineTree(false);
                break;
            }
            case DELTA: {
                worldgenerator = new WorldGenAppleTree(false);
                break;
            }
            case ECHO: {
                worldgenerator = new WorldTreeCherryFruit(false);
                break;
            }
            case FOX: {
                worldgenerator = new WorldGenAcaciaTree(false);
                break;
            }
            case GOLF: {
                worldgenerator = new WorldGenAspenTree(false);
                break;
            }
            case HOTEL: {
                worldgenerator = new WorldGenMistletoeTree(false);
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocksimple$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocksimple$enumtype.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        ALPHA(0, "alpha"),
        BRAVO(1, "bravo"),
        CHARLIE(2, "charlie"),
        DELTA(3, "delta"),
        ECHO(4, "echo"),
        FOX(5, "fox"),
        GOLF(6, "golf"),
        HOTEL(7, "hotel");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocksimple$enumtype;
                EnumType.META_LOOKUP[blocksimple$enumtype.getMetadata()] = blocksimple$enumtype = enumTypeArray[i];
            }
        }
    }
}

