/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.command;

import com.conquestreforged.common.entity.painting.PaintingArt;
import com.conquestreforged.common.entity.painting.PaintingType;
import com.conquestreforged.common.entity.painting.art.Art;
import com.conquestreforged.common.entity.painting.art.ModArt;
import com.conquestreforged.common.entity.painting.art.VanillaArt;
import com.conquestreforged.common.item.PaintingItem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class PaintCommand
implements ICommand {
    public String func_71517_b() {
        return "paint";
    }

    public String func_71518_a(ICommandSender sender) {
        return "paint <type> <art>";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("paint");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String art;
        if (args.length != 2) {
            throw new CommandException("Command requires 2 arguments", new Object[0]);
        }
        String name = args[0];
        PaintingType type = PaintingType.fromName(name);
        if (!name.equalsIgnoreCase("Vanilla") && !type.isPresent()) {
            throw new CommandException("Unknown painting type " + name, new Object[0]);
        }
        if (type.isPresent()) {
            name = type.getName();
        }
        if (!Art.valid(art = args[1], VanillaArt.ALL) && !Art.valid(art, ModArt.ALL)) {
            throw new CommandException("Unknown art type " + art, new Object[0]);
        }
        ItemStack stack = PaintingItem.createStack(name, art);
        EntityPlayerMP player = (EntityPlayerMP)sender;
        player.field_71071_by.func_70441_a(stack);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(0, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 0) {
            return PaintCommand.suggestions(PaintingType.getIds(), "");
        }
        if (args.length == 1) {
            return PaintCommand.suggestions(PaintingType.getIds(), args[0]);
        }
        if (args.length == 2) {
            return PaintCommand.suggestions(PaintingArt.getNames(), args[1]);
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    private static List<String> suggestions(Stream<String> stream, String input) {
        String arg = input.toLowerCase();
        return stream.filter(s -> !s.equalsIgnoreCase(arg) && s.toLowerCase().startsWith(arg)).collect(Collectors.toList());
    }
}

