/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data;

import com.conquestreforged.common.data.block.BlockData;
import com.conquestreforged.common.data.item.ItemData;
import com.conquestreforged.common.data.registry.BlockPropertyRegistry;
import com.conquestreforged.common.data.registry.ItemPropertyRegistry;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public interface DataProcessor {
    default public void process(ResourceLocation location, JsonElement json) {
        ItemPropertyRegistry items = ItemPropertyRegistry.getInstance();
        BlockPropertyRegistry blocks = BlockPropertyRegistry.getInstance();
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            BlockData data = this.process(location, (String)entry.getKey(), (JsonElement)entry.getValue());
            if (!data.isPresent()) continue;
            if (BlockData.class.isInstance(data)) {
                data.registerBlockData(blocks);
            }
            if (!ItemData.class.isInstance(data)) continue;
            data.registerItemData(items);
        }
    }

    public BlockData process(ResourceLocation var1, String var2, JsonElement var3);
}

