/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data;

import com.conquestreforged.common.data.DataProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class DataProcessors {
    private static final DataProcessors instance = new DataProcessors();
    private final Map<String, DataProcessor> processors = new HashMap<String, DataProcessor>();

    private DataProcessors() {
    }

    public void register(String type, DataProcessor processor) {
        this.processors.put(type, processor);
    }

    public Optional<DataProcessor> getProcessor(String type) {
        return Optional.ofNullable(this.processors.get(type));
    }

    public static DataProcessors getInstance() {
        return instance;
    }
}

