/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data;

import com.conquestreforged.common.data.Key;
import com.conquestreforged.common.data.Value;
import java.util.Collections;
import java.util.Map;

public class DataStore {
    public static final DataStore EMPTY = new DataStore(Collections.emptyMap());
    private final Map<Key<?>, Value<?>> data;

    public DataStore(Map<Key<?>, Value<?>> data) {
        this.data = data;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public boolean supports(Key<?> key) {
        return this.isPresent() && this.data.containsKey(key);
    }

    public <T> Value<T> get(Key<T> key) {
        if (this.isPresent()) {
            return key.map(this.data.getOrDefault(key, Value.empty));
        }
        return Value.empty();
    }

    public <T> boolean offer(Key<T> key, Value<T> value) {
        if (this.supports(key)) {
            this.data.put(key, value);
            return true;
        }
        return false;
    }

    public <T> boolean offer(Key<T> key, T value) {
        if (this.supports(key)) {
            this.data.put(key, Value.of(value));
            return true;
        }
        return false;
    }

    public <T> void set(Key<?> key, Value<T> value) {
        if (this.isPresent()) {
            this.data.put(key, value);
        }
    }

    public <T> void set(Key<?> key, T value) {
        if (this.isPresent()) {
            this.data.put(key, Value.of(value));
        }
    }
}

