/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data;

import com.conquestreforged.common.data.Value;

public final class Key<T> {
    private final Class<T> type;

    private Key(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Value<T> map(Value<?> value) {
        if (value.isPresent() && this.type.isInstance(value.getValue())) {
            return value;
        }
        return Value.empty();
    }

    public static <T> Key<T> of(Class<T> type) {
        return new Key<T>(type);
    }
}

