/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data;

import com.google.common.base.Preconditions;

public class Value<T> {
    static final Value<?> empty = new Value<String>("empty");
    private final T value;

    private Value(T value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this != empty;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.isPresent() ? this.value.hashCode() : 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!Value.class.isInstance(other)) {
            return false;
        }
        Value val = (Value)other;
        return this == val || this.isPresent() && val.isPresent() && this.value.equals(val.value);
    }

    public static <T> Value<T> empty() {
        return empty;
    }

    public static <T> Value<T> of(T t) {
        Preconditions.checkNotNull(t);
        return new Value<T>(t);
    }
}

