/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data.block;

import com.conquestreforged.common.data.AbstractData;
import com.conquestreforged.common.data.Key;
import com.conquestreforged.common.data.registry.PropertyRegistry;
import com.conquestreforged.common.util.StateMatcher;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public abstract class BlockData
extends AbstractData {
    private final ResourceLocation location;
    private final String rule;

    public BlockData(Key<?> key, ResourceLocation location, String rule) {
        super(key);
        this.location = location;
        this.rule = rule;
    }

    @Override
    public void registerBlockData(PropertyRegistry<IBlockState> registry) {
        if (this.location == null || this.rule.isEmpty()) {
            return;
        }
        Optional<StateMatcher> stateMatcher = StateMatcher.of(this.location, this.rule);
        if (!stateMatcher.isPresent()) {
            return;
        }
        StateMatcher matcher = stateMatcher.get();
        if (!matcher.isPresent()) {
            return;
        }
        for (Block block : Block.field_149771_c) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                if (!matcher.matches(state)) continue;
                registry.register(state, this.getKey(), this);
            }
        }
    }

    public String toString() {
        return String.format("%s::%s[%s]", this.getClass().getSimpleName(), this.location, this.rule);
    }
}

