/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data.block.harvest;

import com.conquestreforged.common.data.Keys;
import com.conquestreforged.common.data.block.BlockData;
import com.conquestreforged.common.data.block.harvest.HarvestDrop;
import com.conquestreforged.common.util.ToolHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HarvestData
extends BlockData {
    public static HarvestData EMPTY = new HarvestData(null, "", Collections.emptyMap());
    private static final Random RNG = new Random();
    private final Map<String, List<HarvestDrop>> drops;

    public HarvestData(ResourceLocation location, String rule, Map<String, List<HarvestDrop>> drops) {
        super(Keys.HARVEST, location, rule);
        this.drops = drops;
    }

    @Override
    public boolean isPresent() {
        return this != EMPTY;
    }

    public void addDrops(ItemStack stack, List<ItemStack> collector) {
        Set<String> tools = ToolHelper.getInstance().getTool(stack);
        String material = ToolHelper.getInstance().getToolMaterial(stack);
        boolean modified = false;
        for (String tool : tools) {
            if (!this.addDrops(tool, material, collector)) continue;
            modified = true;
        }
        if (modified || tools == ToolHelper.HAND) {
            return;
        }
        this.addDrops("tool", material, collector);
    }

    private boolean addDrops(String tool, String material, Collection<ItemStack> collector) {
        boolean modified = false;
        if (this.addDrops(tool, collector)) {
            modified = true;
        }
        if (!material.isEmpty() && this.addDrops(String.join((CharSequence)".", tool, material), collector)) {
            modified = true;
        }
        return modified;
    }

    private boolean addDrops(String tool, Collection<ItemStack> collector) {
        List list = this.drops.getOrDefault(tool, Collections.emptyList());
        if (list.isEmpty()) {
            return false;
        }
        for (HarvestDrop drop : list) {
            if (!(drop.getChance() >= RNG.nextFloat())) continue;
            collector.add(drop.getStack());
        }
        return true;
    }
}

