/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data.block.harvest;

import com.conquestreforged.common.data.DataProcessor;
import com.conquestreforged.common.data.block.BlockData;
import com.conquestreforged.common.data.block.harvest.HarvestData;
import com.conquestreforged.common.data.block.harvest.HarvestDrop;
import com.conquestreforged.common.data.item.ItemState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class HarvestProcessor
implements DataProcessor {
    @Override
    public BlockData process(ResourceLocation location, String rule, JsonElement json) {
        if (!json.isJsonObject()) {
            return HarvestData.EMPTY;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry e : json.getAsJsonObject().entrySet()) {
            if (!((JsonElement)e.getValue()).isJsonObject()) continue;
            String tool = (String)e.getKey();
            ImmutableList.Builder list = ImmutableList.builder();
            for (Map.Entry c : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                float chance;
                ItemState item = ItemState.parse((String)c.getKey());
                HarvestDrop drop = new HarvestDrop(item, chance = ((JsonElement)c.getValue()).getAsFloat());
                if (!drop.isPresent()) continue;
                list.add((Object)drop);
            }
            map.put((Object)tool, (Object)list.build());
        }
        ImmutableMap drops = map.build();
        if (drops.isEmpty()) {
            return HarvestData.EMPTY;
        }
        return new HarvestData(location, rule, (Map<String, List<HarvestDrop>>)drops);
    }
}

