/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data.item;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemState {
    private final Item item;
    private final ItemStack stack;
    private final int hashCode;

    public ItemState(ItemStack stack) {
        this.item = stack.func_77973_b();
        this.stack = stack;
        this.hashCode = 31 * stack.func_77973_b().hashCode() + stack.func_77960_j();
    }

    public boolean isPresent() {
        return this.stack != ItemStack.field_190927_a;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getStack() {
        if (this.isPresent()) {
            return this.stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        ResourceLocation name = this.stack.func_77973_b().getRegistryName();
        if (name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(name.toString());
        boolean first = true;
        if (this.stack.func_190916_E() > 1) {
            sb.append('[').append("quantity=").append(this.stack.func_190916_E());
            first = false;
        }
        if (this.stack.func_77960_j() > 0) {
            sb.append(first ? (char)'[' : ',').append("metadata=").append(this.stack.func_77960_j());
            first = false;
        }
        if (!first) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static ItemState of(ItemStack stack) {
        return new ItemState(stack);
    }

    public static ItemState parse(String input) {
        int meta = 0;
        int amount = 1;
        int start = input.indexOf(91);
        start = start < 0 ? input.length() : start;
        String name = input.substring(0, start);
        AtomicInteger index = new AtomicInteger(start + 1);
        block4: for (int i = index.get(); i < input.length(); ++i) {
            char c = input.charAt(i);
            int next = input.indexOf(61, i);
            if (next == -1) continue;
            index.set(next + 1);
            Number num = ItemState.parseNumber(input, index);
            i = index.get();
            switch (c) {
                case 'm': {
                    meta = num.intValue();
                    continue block4;
                }
                case 'a': {
                    amount = num.intValue();
                }
            }
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        ItemStack stack = item != null ? new ItemStack(item, Math.max(1, amount), Math.max(0, meta)) : ItemStack.field_190927_a;
        return new ItemState(stack);
    }

    private static Number parseNumber(String in, AtomicInteger index) {
        int i;
        float num = 0.0f;
        int decimals = 0;
        for (i = index.get(); i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isDigit(c)) {
                float val = c - 48;
                if (decimals > 0) {
                    num += val / (float)(decimals *= 10);
                    continue;
                }
                num = num * 10.0f + val;
                continue;
            }
            if (c != '.' || decimals != 0) break;
            decimals = 1;
        }
        index.set(i);
        return Float.valueOf(num);
    }
}

