/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.data.registry;

import com.conquestreforged.common.data.DataStore;
import com.conquestreforged.common.data.Key;
import com.conquestreforged.common.data.Value;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyRegistry<T> {
    private final Map<T, DataStore> registry = new ConcurrentHashMap<T, DataStore>();

    public DataStore getStore(T id) {
        return this.registry.getOrDefault(id, DataStore.EMPTY);
    }

    public void register(T id, DataStore store) {
        if (store.isPresent()) {
            this.registry.put(id, store);
        }
    }

    public boolean supports(T id, Key<?> key) {
        return this.getStore(id).supports(key);
    }

    public <V> Value<V> getValue(T id, Key<V> key) {
        return this.getStore(id).get(key);
    }

    public <V> boolean offer(T id, Key<V> key, V value) {
        return this.offer(id, key, Value.of(value));
    }

    public <V> boolean offer(T id, Key<V> key, Value<V> value) {
        return this.getStore(id).offer(key, value);
    }

    public void register(T id, Key<?> key, Object value) {
        this.register(id, key, Value.of(value));
    }

    public void register(T id, Key<?> key, Value<?> value) {
        DataStore store = this.getStore(id);
        if (!store.isPresent()) {
            store = new DataStore(Maps.newHashMap());
            this.register(id, store);
        }
        store.set(key, value);
    }
}

