/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.entity.painting;

import com.conquestreforged.common.entity.painting.PaintingArt;
import com.conquestreforged.common.entity.painting.PaintingType;
import com.conquestreforged.common.item.PaintingItem;
import com.conquestreforged.common.network.BufHelper;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintingEntity
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private PaintingType type;
    private PaintingArt art = PaintingArt.A1x1_0;

    public PaintingEntity(World worldIn) {
        super(worldIn);
    }

    public PaintingType getType() {
        return this.type;
    }

    public PaintingArt getArt() {
        return this.art;
    }

    public void place(BlockPos pos, EnumFacing side) {
        this.field_174861_a = pos;
        this.func_174859_a(side);
    }

    public void setType(PaintingType type) {
        this.type = type;
        if (this.field_174860_b != null) {
            this.func_174859_a(this.field_174860_b);
        }
    }

    public void setArt(PaintingArt art) {
        this.art = art;
        if (this.field_174860_b != null) {
            this.func_174859_a(this.field_174860_b);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return PaintingItem.createStack(this.type.getName(), this.art.getName());
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack drop;
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            if ((drop = PaintingItem.createStack(this.getType().getName(), this.getArt().getName())) != ItemStack.field_190927_a) {
                this.func_70099_a(drop, 0.0f);
            }
        }
    }

    public boolean func_70518_d() {
        return true;
    }

    public int func_82329_d() {
        return this.art.sizeX;
    }

    public int func_82330_g() {
        return this.art.sizeY;
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("TypeID", this.type.getName());
        tagCompound.func_74768_a("ArtID", this.art.index());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        String type = tagCompound.func_74779_i("TypeID");
        int id = tagCompound.func_74762_e("ArtID");
        this.type = PaintingType.fromId(type);
        this.art = PaintingArt.fromId(id);
        super.func_70037_a(tagCompound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
        buffer.writeInt(this.func_174811_aO().func_176745_a());
        BufHelper.writeUTF8(this.getType().getName(), buffer);
        BufHelper.writeUTF8(this.getArt().shapeId, buffer);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int x = additionalData.readInt();
        int y = additionalData.readInt();
        int z = additionalData.readInt();
        int facing = additionalData.readInt();
        String type = BufHelper.readUTF8(additionalData);
        String art = BufHelper.readUTF8(additionalData);
        this.type = PaintingType.fromId(type);
        this.art = PaintingArt.fromName(art);
        this.func_70107_b(x, y, z);
        this.func_174859_a(EnumFacing.func_82600_a((int)facing));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float a, float b, int c, boolean d) {
        BlockPos pos = this.field_174861_a.func_177963_a(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

