/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.entity.painting;

import com.conquestreforged.common.entity.painting.Translateable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public class PaintingType
implements Translateable {
    private static final PaintingType UNKNOWN = new PaintingType("unknown");
    private static final Map<String, PaintingType> types = new ConcurrentHashMap<String, PaintingType>();
    private final String name;
    private final ResourceLocation location;

    private PaintingType(String name) {
        this.name = name;
        this.location = new ResourceLocation("conquest", "textures/paintings/" + name + ".png");
    }

    public boolean isPresent() {
        return this != UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return this.getUnlocalizedName("conquest");
    }

    @Override
    public String getUnlocalizedName(String parent) {
        return parent + "." + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public static PaintingType fromId(String id) {
        if (id == null) {
            return UNKNOWN;
        }
        return types.getOrDefault(id, UNKNOWN);
    }

    public static PaintingType fromName(String name) {
        PaintingType type = PaintingType.fromId(name);
        if (type != UNKNOWN) {
            return type;
        }
        for (PaintingType t : types.values()) {
            if (name.equalsIgnoreCase(t.getName())) {
                return t;
            }
            if (!name.equalsIgnoreCase(t.getDisplayName())) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static void register(String id) {
        types.put(id, new PaintingType(id));
    }

    public static Stream<String> getIds() {
        return types.values().stream().map(PaintingType::getName);
    }

    public static List<PaintingType> getOrderedTypes() {
        return types.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

