/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.entity.seat;

import com.conquestreforged.common.data.block.seat.SeatData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class Seat
extends Entity
implements IEntityAdditionalSpawnData {
    public static final Data DEFAULT = Seat.height(Float.MIN_VALUE);
    public static final Data EMPTY = Seat.height(0.0f);
    private float rideHeight = Float.MIN_VALUE;

    public Seat(World worldIn) {
        super(worldIn);
        this.field_70131_O = 0.0f;
        this.field_70130_N = 0.0f;
    }

    public void setSeatData(SeatData data) {
        if (data.isPresent()) {
            this.rideHeight = data.getRideHeight();
        }
    }

    public void setBlockPosition(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        AxisAlignedBB box = state.func_185900_c((IBlockAccess)this.field_70170_p, pos);
        double x = (double)pos.func_177958_n() + (box.field_72336_d - box.field_72340_a) / 2.0;
        double z = (double)pos.func_177952_p() + (box.field_72334_f - box.field_72339_c) / 2.0;
        super.func_70107_b(x, (double)pos.func_177956_o(), z);
    }

    public double func_70042_X() {
        return this.rideHeight;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184188_bt().isEmpty()) {
                this.field_70170_p.func_72900_e((Entity)this);
            }
            if (this.field_70170_p.func_175623_d(this.func_180425_c())) {
                this.field_70170_p.func_72900_e((Entity)this);
            }
        }
    }

    protected void func_70088_a() {
        this.setBlockPosition(this.func_180425_c());
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public static Data height(float rideHeight) {
        return new Data(rideHeight);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.rideHeight);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.rideHeight = buffer.readFloat();
    }

    public static class Data {
        private float rideHeight;

        private Data(float rideHeight) {
            this.rideHeight = rideHeight;
        }

        public boolean isPresent() {
            return this != EMPTY;
        }
    }
}

