/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.event.handler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootTableHandler {
    private static final List<String> TABLES = ImmutableList.of((Object)"inject/abandoned_mineshaft", (Object)"inject/desert_pyramid", (Object)"inject/jungle_temple", (Object)"inject/simple_dungeon", (Object)"inject/spawn_bonus_chest", (Object)"inject/stronghold_corridor", (Object)"inject/village_blacksmith");

    public LootTableHandler() {
        for (String s : TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("conquest", s));
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": 
                case "village_blacksmith": {
                    evt.getTable().addPool(this.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "conquest_inject_pool");
    }

    private LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("inject/" + name), weight, 0, new LootCondition[0], "conquest_inject_entry");
    }
}

