/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.event.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TreeFellHandler {
    private static final int SEARCH_LIMIT = 1000;

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (e.getPlayer() == null || e.getPlayer().func_184812_l_()) {
            return;
        }
        BlockPos pos = e.getPos();
        IBlockState state = e.getState();
        Block block = state.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return;
        }
        HashMap<BlockPos, IBlockState> visited = new HashMap<BlockPos, IBlockState>(1000);
        if (this.treeShouldFall(e.getWorld(), e.getPos(), true, visited)) {
            this.simulateBlockFall(visited, world, pos, e.getPlayer().func_174811_aO());
        }
    }

    private boolean treeShouldFall(World world, BlockPos pos, boolean first, Map<BlockPos, IBlockState> body) {
        if (body.size() > 1000) {
            return false;
        }
        if (body.containsKey(pos)) {
            return true;
        }
        if (world.func_175623_d(pos)) {
            body.put(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        boolean log = state.func_177230_c().isWood((IBlockAccess)world, pos);
        boolean leaves = state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
        boolean result = true;
        if (log || leaves) {
            body.put(pos, state);
            result = this.treeShouldFall(world, pos.func_177984_a(), false, body);
            result = result && this.treeShouldFall(world, pos.func_177978_c(), false, body);
            result = result && this.treeShouldFall(world, pos.func_177974_f(), false, body);
            result = result && this.treeShouldFall(world, pos.func_177968_d(), false, body);
            boolean bl = result = result && this.treeShouldFall(world, pos.func_177976_e(), false, body);
            if (!first) {
                result = result && this.treeShouldFall(world, pos.func_177977_b(), false, body);
            }
        } else if (state.func_185904_a().func_76220_a()) {
            return false;
        }
        return result;
    }

    private void simulateBlockFall(Map<BlockPos, IBlockState> body, World world, BlockPos original, EnumFacing facing) {
        BlockPos size = TreeFellHandler.calcSize(body, world);
        if (size == BlockPos.field_177992_a) {
            return;
        }
        int dir = 1;
        EnumFacing.Axis direction = EnumFacing.Axis.Y;
        BlockPos origin = original;
        if (size.func_177958_n() <= size.func_177956_o() && size.func_177952_p() <= size.func_177956_o()) {
            direction = facing.func_176740_k();
            dir = facing.func_176743_c().func_179524_a();
            origin = original.func_177971_a(facing.func_176730_m());
        }
        for (Map.Entry<BlockPos, IBlockState> e : body.entrySet()) {
            if (e.getValue().func_177230_c() == Blocks.field_150350_a) continue;
            world.func_175655_b(e.getKey(), false);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos next = new BlockPos.MutableBlockPos();
        for (Map.Entry<BlockPos, IBlockState> e : body.entrySet()) {
            if (e.getValue().func_177230_c() == Blocks.field_150350_a || e.getKey().equals((Object)original)) continue;
            IBlockState state = TreeFellHandler.rotateAxis(e.getValue(), EnumFacing.Axis.Y, direction);
            TreeFellHandler.relativize(pos, e.getKey(), origin);
            TreeFellHandler.rotate(pos, direction, dir);
            TreeFellHandler.offset(pos, origin);
            TreeFellHandler.fall(pos, next, world);
            world.func_175656_a((BlockPos)pos, state);
        }
    }

    private static void relativize(BlockPos.MutableBlockPos pos, BlockPos in, BlockPos origin) {
        int relX = in.func_177958_n() - origin.func_177958_n();
        int relY = in.func_177956_o() - origin.func_177956_o();
        int relZ = in.func_177952_p() - origin.func_177952_p();
        pos.func_181079_c(relX, relY, relZ);
    }

    private static void rotate(BlockPos.MutableBlockPos pos, EnumFacing.Axis direction, int dir) {
        if (direction == EnumFacing.Axis.Y) {
            return;
        }
        int rotX = direction == EnumFacing.Axis.X ? pos.func_177956_o() * dir : pos.func_177958_n();
        int rotY = direction == EnumFacing.Axis.X ? pos.func_177958_n() : pos.func_177952_p();
        int rotZ = direction == EnumFacing.Axis.X ? pos.func_177952_p() : pos.func_177956_o() * dir;
        pos.func_181079_c(rotX, rotY, rotZ);
    }

    private static void offset(BlockPos.MutableBlockPos pos, BlockPos origin) {
        pos.func_181079_c(pos.func_177958_n() + origin.func_177958_n(), pos.func_177956_o() + origin.func_177956_o(), pos.func_177952_p() + origin.func_177952_p());
    }

    private static void fall(BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos next, World world) {
        next.func_189533_g((Vec3i)pos);
        boolean inSolid = world.func_180495_p((BlockPos)next).func_185904_a().func_76220_a();
        while (world.func_180495_p((BlockPos)next).func_185904_a().func_76220_a() == inSolid) {
            pos.func_189533_g((Vec3i)next);
            next.func_185336_p(inSolid ? next.func_177956_o() + 1 : next.func_177956_o() - 1);
        }
        if (inSolid) {
            pos.func_189533_g((Vec3i)next);
        }
    }

    private static BlockPos calcSize(Map<BlockPos, IBlockState> body, World world) {
        BlockPos min = BlockPos.field_177992_a;
        BlockPos max = BlockPos.field_177992_a;
        for (Map.Entry<BlockPos, IBlockState> e : body.entrySet()) {
            if (e.getValue().func_177230_c().isWood((IBlockAccess)world, e.getKey())) continue;
            min = TreeFellHandler.min(min, e.getKey());
            max = TreeFellHandler.max(max, e.getKey());
        }
        return max.func_177973_b((Vec3i)min);
    }

    private static BlockPos min(BlockPos p1, BlockPos p2) {
        if (p1 == BlockPos.field_177992_a) {
            return p2;
        }
        if (p2 == BlockPos.field_177992_a) {
            return p1;
        }
        int x = Math.min(p1.func_177958_n(), p2.func_177958_n());
        int y = Math.min(p1.func_177956_o(), p2.func_177956_o());
        int z = Math.min(p1.func_177952_p(), p2.func_177952_p());
        return new BlockPos(x, y, z);
    }

    private static BlockPos max(BlockPos p1, BlockPos p2) {
        if (p1 == BlockPos.field_177992_a) {
            return p2;
        }
        if (p2 == BlockPos.field_177992_a) {
            return p1;
        }
        int x = Math.max(p1.func_177958_n(), p2.func_177958_n());
        int y = Math.max(p1.func_177956_o(), p2.func_177956_o());
        int z = Math.max(p1.func_177952_p(), p2.func_177952_p());
        return new BlockPos(x, y, z);
    }

    private static <T extends Comparable<T>> IBlockState rotateAxis(IBlockState state, EnumFacing.Axis axis, EnumFacing.Axis direction) {
        if (direction == EnumFacing.Axis.Y) {
            return state;
        }
        for (IProperty p : state.func_177228_b().keySet()) {
            if (!p.func_177701_a().equals("axis")) continue;
            IProperty prop = p;
            String current = state.func_177229_b(prop).toString();
            String match = "";
            if (current.equals(axis.func_176610_l())) {
                match = direction.func_176610_l();
            } else if (current.equals(direction.func_176610_l())) {
                match = axis.func_176610_l();
            }
            if (match.isEmpty()) break;
            for (Comparable val : prop.func_177700_c()) {
                if (!val.toString().equals(match)) continue;
                return state.func_177226_a(prop, val);
            }
        }
        return state;
    }
}

