/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.item;

import com.conquestreforged.common.entity.painting.PaintingArt;
import com.conquestreforged.common.entity.painting.PaintingEntity;
import com.conquestreforged.common.entity.painting.PaintingType;
import java.util.Comparator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PaintingItem
extends Item {
    public PaintingItem() {
        this.func_77655_b("conquest_painting");
        this.setRegistryName("conquest", "painting");
    }

    public PaintingItem(String name) {
        this.func_77655_b(name);
        this.setRegistryName("conquest", name);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (((Object)((Object)this)).getClass() == PaintingItem.class && (this.func_77640_w() == tab || tab == CreativeTabs.field_78027_g)) {
            PaintingType.getIds().distinct().sorted(Comparator.reverseOrder()).forEach(name -> {
                String type = PaintingType.fromName(name).getName();
                ItemStack stack = PaintingItem.createStack(type, PaintingArt.A1x1_0.shapeId);
                items.add((Object)stack);
            });
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound painting = stack.func_77978_p();
        if (painting == null) {
            return super.func_77667_c(stack);
        }
        NBTTagCompound data = painting.func_74775_l("Painting");
        String typeName = data.func_74779_i("TypeID");
        String artName = data.func_74779_i("ArtID");
        PaintingType type = PaintingType.fromId(typeName);
        String displayName = this.func_77658_a();
        if (type.isPresent()) {
            displayName = type.getDisplayName();
            PaintingArt art = PaintingArt.fromName(artName);
            if (art != null) {
                displayName = displayName + " " + art.getDisplayName(type.getUnlocalizedName());
            }
        } else if (!artName.isEmpty()) {
            displayName = artName;
        }
        return displayName;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.func_77659_a(world, player, hand);
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound data = stack.func_77978_p();
        if (data == null) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound paint = data.func_74775_l("Painting");
        String paintType = paint.func_74779_i("TypeID");
        String paintArt = paint.func_74779_i("ArtID");
        if (paintType.isEmpty() || paintArt.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
            EntityHanging painting = this.createEntity(world, pos = pos.func_177972_a(side), side, paintType, paintArt);
            if (painting == null) {
                return EnumActionResult.FAIL;
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)painting);
                painting.func_184523_o();
            }
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected EntityHanging createEntity(World world, BlockPos pos, EnumFacing side, String paintType, String paintArt) {
        PaintingType type = PaintingType.fromName(paintType);
        PaintingArt art = PaintingArt.fromName(paintArt);
        if (!type.isPresent() || art == null) {
            return null;
        }
        PaintingEntity painting = new PaintingEntity(world);
        painting.setType(type);
        painting.setArt(art);
        painting.place(pos, side);
        return painting;
    }

    public static ItemStack createStack(String type, String art) {
        return PaintingItem.createStack(type, art, 1);
    }

    public static ItemStack createStack(String type, String art, int size) {
        Item item = type.equalsIgnoreCase("Vanilla") ? Item.func_111206_d((String)"conquest:vanilla_painting") : Item.func_111206_d((String)"conquest:painting");
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound painting = new NBTTagCompound();
        painting.func_74778_a("TypeID", type);
        painting.func_74778_a("ArtID", art);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74782_a("Painting", (NBTBase)painting);
        ItemStack stack = new ItemStack(item, size);
        stack.func_77982_d(data);
        return stack;
    }
}

