/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.item.brush;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface BrushAction {
    public static final SoundEvent SOUND_EVENT = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.item.pickup"));

    default public void primary(EntityPlayer player, World world, BlockPos pos, IBlockState current, IBlockState paint, ItemStack source) {
        ItemStack drop = current.func_177230_c().getPickBlock(current, null, world, pos, player);
        IBlockState state = this.getPaint(current, paint);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        if (world.func_175656_a(pos, state)) {
            if (!player.func_184812_l_()) {
                source.func_190920_e(source.func_190916_E() - 1);
                player.func_191521_c(drop);
            }
            if (SOUND_EVENT != null) {
                world.func_184133_a(null, pos, SOUND_EVENT, SoundCategory.AMBIENT, 0.35f, 1.0f);
            }
        }
    }

    default public void secondary(EntityPlayer player, World world, BlockPos pos, IBlockState current, IBlockState paint, ItemStack source) {
        if (player.func_184812_l_()) {
            ItemStack stack = current.func_177230_c().getPickBlock(current, null, world, pos, player);
            player.func_184611_a(EnumHand.OFF_HAND, stack);
        } else {
            ItemStack stack = current.func_177230_c().getPickBlock(current, null, world, pos, player);
            int slot = BrushAction.findSlot(player.field_71071_by, stack.func_77973_b(), stack.func_77960_j());
            if (slot != -1) {
                stack = player.field_71071_by.func_70301_a(slot);
                player.func_184611_a(EnumHand.OFF_HAND, stack);
                player.field_71071_by.func_70304_b(slot);
            }
        }
    }

    public IBlockState getPaint(IBlockState var1, IBlockState var2);

    public static int findSlot(InventoryPlayer inventory, Item item, int meta) {
        NonNullList stacks = inventory.field_70462_a;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            if (stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            return i;
        }
        return -1;
    }
}

