/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util;

import com.google.common.collect.HashMultimap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.util.ResourceLocation;

public class AssetPack
implements Closeable {
    private static final Pattern DATA_PATTERN = Pattern.compile("assets/(.*?)/data/(.*?)/(.*?).json");
    private final ZipFile zipFile;

    public AssetPack(File jar) throws IOException {
        this.zipFile = new ZipFile(jar);
    }

    public InputStream getResource(ResourceLocation location) throws IOException {
        String path = String.format("assets/%s/%s", location.func_110624_b(), location.func_110623_a());
        ZipEntry entry = new ZipEntry(path);
        return this.zipFile.getInputStream(entry);
    }

    public InputStream getBlockList(String domain) throws IOException {
        String path = String.format("assets/%s/blocks/_registry.index", domain);
        ZipEntry entry = new ZipEntry(path);
        return this.zipFile.getInputStream(entry);
    }

    public <T> List<T> loadAll(Pattern pattern, Function<InputStream, T> mapper) {
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        LinkedList<T> list = new LinkedList<T>();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (!pattern.matcher(entry.getName()).find()) continue;
            try {
                InputStream inputStream = this.zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    T t = mapper.apply(inputStream);
                    if (t == null) continue;
                    list.add(t);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public InputStream getBlockInfo(ResourceLocation location) throws IOException {
        String path = String.format("assets/%s/blocks/%s.conf", location.func_110624_b(), location.func_110623_a());
        ZipEntry entry = new ZipEntry(path);
        return this.zipFile.getInputStream(entry);
    }

    public InputStream getData(String type, ResourceLocation location) throws IOException {
        String path = String.format("assets/%s/data/%s/%s.json", location.func_110624_b(), type, location.func_110623_a());
        ZipEntry entry = new ZipEntry(path);
        return this.zipFile.getInputStream(entry);
    }

    public HashMultimap<String, ResourceLocation> getDataLocations() {
        HashMultimap map = HashMultimap.create();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry next = enumeration.nextElement();
            Matcher matcher = DATA_PATTERN.matcher(next.getName());
            if (!matcher.find() || matcher.groupCount() != 3) continue;
            String domain = matcher.group(1);
            String data = matcher.group(2);
            String block = matcher.group(3);
            ResourceLocation location = new ResourceLocation(domain, block);
            map.put((Object)data, (Object)location);
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

