/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util;

import com.conquestreforged.common.util.ref.Ref;
import java.lang.reflect.Field;
import java.util.Map;

public class FieldUtil {
    public static <T> T get(Object src, String field, Class<T> type, T def) {
        for (Class<?> c = src.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.getName().equalsIgnoreCase(field)) continue;
                try {
                    f.setAccessible(true);
                    return type.cast(f.get(src));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return def;
                }
            }
        }
        return def;
    }

    public static void getRefMeta(Object src, Map<String, String> meta) {
        for (Class<?> c = src.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!Ref.class.isAssignableFrom(f.getType())) continue;
                try {
                    f.setAccessible(true);
                    Object value = f.get(src);
                    meta.put(f.getName(), value.toString());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void set(Object src, String name, Object value) {
        try {
            Field field = src.getClass().getDeclaredField(name);
            field.set(src, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

